#ifndef PROFILE_H
#define PROFILE_H

typedef unsigned char BYTE;
typedef unsigned int WORD;
typedef unsigned long DWORD;
typedef int BOOL;

#define LOWORD(l)           ((WORD)(l))
#define HIWORD(l)           ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)(((WORD)(w) >> 8) & 0xFF))

#define MAPPHYS 0x800
#define	MGABS1LMT 0x3FFF

struct profile {
      char *name;
      BYTE m;   /* SYSPLLM    0x2C */
      BYTE n;   /* SYSPLLN    0x2D */
      BYTE pllp;   /* SYSPLLP    0x2E */
      WORD opt1;
      WORD opt2;
      WORD opt3;
};

struct syspllp {
      BYTE p                   :3;
      BYTE s                   :2;
      BYTE reserved            :3;
};

struct mgabase {
      WORD memspaceind          :1;
      WORD type                 :2;
      WORD prefetchable         :1;
      WORD reserved0            :10;
      WORD mgabase1             :18;
};

struct mctlwtst {
      WORD casltncy             :3;
      WORD reserved0            :1;
      WORD rrddelay             :2;
      WORD reserved1            :1;
      WORD rcddelay             :2;
      WORD reserved2            :1;
      WORD rasmin               :3;
      WORD reserved3            :1;
      WORD rpdelay              :2;
      WORD reserved4            :2;
      WORD wrdelay              :2;
      WORD reserved5            :1;
      WORD rddelay              :1;
      WORD reserved6            :1;
      WORD smrdelay             :2;
      WORD reserved7            :1;
      WORD bwcdelay             :2;
      WORD reserved8            :1;
      WORD bpldelay             :3;
};

struct memrdbk {
      WORD mclkbrd0             :4;
      WORD reserved0            :1;
      WORD mclkbrd1             :4;
      WORD reserved1            :13;
      WORD strmfctl             :2;
      WORD reserved2            :1;
      WORD mrsopcod             :5;
      WORD reserved3            :2;
};

struct g400_option {
      WORD reserved0            :2;
      WORD sysclkdis		:1;
      WORD reserved1            :2;
      WORD syspllpdn		:1;
      WORD pllsel		:1;
      WORD reserved2		:1;
      WORD memconfig		:3;
      WORD reserved3		:1;
      WORD hardpwmsk		:1;
      WORD rfhcnt		:6;
      WORD reserved4		:1;
      WORD enhmemacc		:3;
      WORD reserved5		:5;
      WORD nohireq		:1;
      WORD noretry		:1;
      WORD biosen		:1;
      WORD powerpc		:1;
};

struct g400_option2 {
      WORD reserved0		:8;
      WORD eepromwt		:1;
      WORD reserved1		:6;
      WORD mod2clkp		:3;
      WORD modclkp		:3;
      WORD reserved2		:2;
      WORD codclksl		:2;
      WORD codprediv		:1;
      WORD codpstdiv		:1;
      WORD reserved3		:4;
};

struct g400_option3 {
      WORD gclksel              :2;
      WORD reserved0            :1;
      WORD gclkdiv              :3;
      WORD gclkdcyc             :4;
      WORD mclksel              :2;
      WORD reserved1            :1;
      WORD mcldiv               :3;
      WORD mclkdcyc             :4;
      WORD wclksel              :2;
      WORD reserved2            :1;
      WORD wclkdiv              :3;
      WORD wclkdcyc             :4;
      WORD reserved3            :2;
};

struct g200_option {
      WORD sysclksl 		:2;
      WORD sysclkdis		:1;
      WORD gclkdiv  		:1;
      WORD mclkdiv  		:1;
      WORD syspllpdn		:1;
      WORD pllsel   		:1;
      WORD reserved0		:1;
      WORD vgaioen  		:1;
      WORD reserved1		:1;
      WORD memconfig		:3;
      WORD reserved2		:1;
      WORD hardpwmsk		:1; /* HW plane write mask */
      WORD rfhcnt   		:6;
      WORD reserved3		:1;
      WORD enhmemacc		:1;
      WORD reserved4		:6;
      WORD noretry		:1; /* PCI Retry */
      WORD biosen 		:1;
      WORD powerpc		:1;
};


struct g200_option2 {
      WORD reserved0		:8;
      WORD eepromwt		:1;
      WORD reserved1		:3;
      WORD mbuftype		:2;
      WORD nogclkdiv		:1;
      WORD nomclkdiv		:1;
      WORD nowclkdiv		:1;
      WORD wclkdiv		:1;
      WORD reserved2		:1;
      WORD modclkp		:3;
      WORD reserved3		:10;
};

#endif
