.TH x_update l "1 Jan 2004"
.SH NAME
\fBx_update\fP \- Archiving of Cross-Over Information
.SH SYNOPSIS
\fBx_update\fP \fIcross-overfile\fP [ \fB\-X\fP\fIxbase\fP ] [ \fB\-L\fP\fIlegbase\fP ]
[ \fB\-V\fP ] [ \fB\-W\fP\fImax\fP ]
.SH DESCRIPTION
\fBx_update\fP reads the ASCII file produced by \fBx_over\fP and writes the information to the
database files \fIxx_base.b\fP and \fIxx_legs.b\fP (unless other filenames are specified on the command
line) using a compact, binary format. The options recognized are:
.TP
.B \-X
Indicate alternate \fIxx_base.b\fP file.
.TP
.B \-L
Indicate alternate \fIxx_legs.b\fP file.
.TP
.B \-V
Verbose. Reports the pair currently being processed.
.TP
.B \-W
Prints a warning if the number of COEs generated by any pair of legs exceed
\fImax\fP.
.SH
For security reasons the \fIxx_legs.b\fP are first renamed to \fIxx_legs.b_old\fP, to prevent loss of
information if a black-out or system crash should occur during writing of the new \fIxx_legs.b\fP
file. It is recommended that the old file is left on the disk in case of other disasters. Note that
\fBx_update\fP does not check if a pair of legs already exist in the \fIxx_base.b\fP file. It is the user's'
responsibility to ensure that duplication of information does not occur. Should some pairs
already in the database need to be re-examined, then run \fBx_remove\fP which will wipe out all
traces of the specified cruises from the x_system data base files. Now we can pass the pairs that
need to be redone through \fBx_over/x_update\fP again.
.SH SEE ALSO
.IR gmt (GMTMANSECTION),
.IR x_system (GMTMANSECTION)
.SH REFERENCES
Wessel, P. XOVER: A Cross-over Error Detector for Track Data,
\fIComputers & Geosciences, 15\fP, 333-346.
