.TH PSSCALE l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
psscale \- Create grayscale or colorscale for maps
.SH SYNOPSIS
\fBpsscale\fP \fB\-D\fP\fIxpos\fP/\fIypos\fP/\fIlength\fP/\fIwidth\fP[\fBh\fP] [ \fB\-A\fP ] [ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] 
[ \fB\-C\fP\fIcpt_file\fP ] [ \fB\-E\fP[\fBb\fP|\fBf\fP][\fIlength\fP] ] [ \fB\-I\fP[\fImax_intens\fP[\fIlow_i\fP/\fIhigh_i\fP]] ] 
[ \fB\-K\fP ] [ \fB\-L\fP[\fBi\fP][\fIgap\fP] ] [ \fB\-M\fP ] 
[ \fB\-N\fP\fIdpi\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] 
[ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-Z\fP\fIzfile\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBpsscale\fP plots grayscales or colorscales on maps.  Both horizontal and vertical scales
are supported.  For cpt_files with gradational colors (i.e., the lower and upper
boundary of an interval have different r/g/b values) \fBpsscale\fP will interpolate to give
a continuous scale.  Variations in intensity due to shading/illumination may be
displayed by setting the option \fB\-I\fP.  Colors may be spaced according to a linear
scale, all be equal size, or by providing a file with individual tile widths.
.TP
.B \-D
Defines the position of the center/top (for horizontal scale) or center/left (for
vertical scale) and the dimensions of the scale.  Append \fIh\fP to get a horizontal
scale [Default is vertical].
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Place annotations above (instead of below) horizontal scalebars and to the left
(instead of the right) of vertical scalebars.
.TP
.B \-B
Set annotation, tick, and gridline interval for the colorbar.  The
xaxis label will plot beneath a horizontal bar (or vertically
to the right of a vertical bar).  As an option, use the yaxis label to
plot the data unit to the right of a horizontal bar (and above a vertical bar).
If no values are provided, the default is to annotate
every color level (which may be overridden by ULB flags in the cpt file).
Note that since vertical labels will be plotted as a column
of individual characters, no octal escape characters embedded in the label are allowed.
Text with such characters will be plotted horizontally (relative to the color scale).
By default, labels are generated from the numerical entries.  To specify custom text
labels for intervals, you must append ;\fIlabel\fP to each z-slice in the cpt file.
.TP
.B \-C
\fIcpt_file\fP is the color palette file to be used.
By default all color changes are annotated.  To use a subset, add an extra column to the
cpt-file with a L, U, or B to annotate Lower, Upper, or Both color segment boundaries (but see \fB\-B\fP).
If not given, \fBpsscale\fP will read stdin.  As for \fBgrdview\fP, \fBpsscale\fP can understand
pattern specifications in the cpt file.
.TP
.B \-E
Add sidebar triangles for \fBb\fPack- and/or \fBf\fPoreground colors.  Add \fBf\fP or \fBb\fP for
only one sidebar triangle [Default gives both].  Optionally, append
triangle height [Default is half the barwidth].
.TP
.B \-I
Add illumination effects.  Optionally, set the range of intensities from
- to + \fImax_intens\fP.  If not specified, 1 is used.  Alternatively,
append \fIlow/high\fP intensities to specify an asymmetric range [Default is no illumination].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Gives equal-sized color rectangles.  Default scales rectangles according to the
z-range in the cpt-file  (Also see \fB\-Z\fP).  If set, any equal interval annotation
set with \fB\-B\fP will be ignored.  If \fIgap\fP is appended and the cpt table is
discrete we will center each annotation on each rectangle, using the lower boundary
z-value for the annotation.  If \fPi\fP is prepended we annotate the interval range instead.
.TP
.B \-M
Force a monochrome graybar using the (television) YIQ transformation.
.TP
.B \-N
Effective dots-per-inch for the rectangular image making up the color scale [300].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Do not separate different colour intervals with black lines.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-Z
File with colorbar-width per color entry.  By default, width of entry is scaled
to color range, i.e., z = 0-100 gives twice the width as z = 100-150 (Also see \fB\-L\fP).
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
To append a vertical colorscale (7.5 cm long; 1.25 cm wide) to the right of a plot that is 6 inch wide and 4 inch
high, using illumination, and show back- and foreground colors, and annotating every 5 units, use
.br
.sp
\fBpsscale\fP \fB\-D\fP6.5\fBi\fP/2\fBi\fP/7.5\fBc\fP/1.25\fBc\fP \fB\-O \-C\fPcolors.cpt \fB\-I \-E\fP \fB\-B\fP5:BATHYMETRY:/:m: >> map.ps
.SH NOTES
When the cpt file is discrete and no illumination is specified, the color bar will be painted
using polygons.  For all other cases we must paint with an image.  Some color printers may give
slightly different colors for the two methods given identical RGB values.
.SH "SEE ALSO"
.IR GMT (l),
.IR makecpt (l),
.IR grd2cpt (l)
