#!/bin/sh
## ----------------------------------------------------------------------------
##                                                                           --
##                      GNADE  : GNu Ada Database Environment                --
##                                                                           --
##  Filename        : $Source: /cvsroot/gnade/gnade/bin/staticlib.sh.in,v $  --
##  Description     : build and install shared libs in the system            --
##  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>
##  Created On      : 9-April-2002
##  Last Modified By: $Author: merdmann $
##  Last Modified On: $Date: 2002/08/31 15:20:37 $
##  Status          : $State: Exp $
##
##  Copyright (C) 2000-2002                                                  --
##                                                                           --
##  GNADE is copyrighted by the persons and institutions enumerated in the   --
##  AUTHORS file. This file is located in the root directory of the          --
##  GNADE distribution.                                                      --
##                                                                           --
##  GNADE is free software;  you can redistribute it  and/or modify it under --
##  terms of the  GNU General Public License as published  by the Free Soft- --
##  ware  Foundation;  either version 2,  or (at your option) any later ver- --
##  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
##  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
##  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
##  for  more details.  You should have  received  a copy of the GNU General --
##  Public License  distributed with GNAT;  see file COPYING.  If not, write --
##  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
##  MA 02111-1307, USA.                                                      --
##                                                                           --
##  As a special exception,  if other files  instantiate  generics from      --
##  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
##  files  to produce an executable, these  units or libraries do not by     --
##  itself cause the resulting  executable  to  be covered  by the  GNU      --
##  General  Public  License.  This exception does not however invalidate    --
##  any other reasons why  the executable file  might be covered by the      --
##  GNU Public License.                                                      --
##                                                                           --
##  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
##                                                                           --
## ----------------------------------------------------------------------------

includedir="/tmp"
opt_clean="n"

##
##
##
usage()
{
	cat <<EOF
Usage: staticlib.sh [OPTIONS] <name>
Options:
	[--include=<targetdir> ]
	[--clean] 

Description:
This script copies the package specifications after compilation
into the specified directory and changes the file permissions in
such a way that the gnat compiler assumes predefined units.

EOF
	exit $1
}

##
## Copy a single unit 
##
copyunit() {
   t=$2/`basename $1` 
   rm -f 0666 $t
   cp $opt_verbose $1 $t
   chmod 0444 $t
}

## ########################################## ##
##            Main Entry                      ##
## ########################################## ##

if test $# -eq 0; then
   usage 1 1>&2
   exit 1;
fi
##
## Scan the arguments
##
includedir=$1
shift

for i in $* ; do
   copyunit $i $includedir
done

##
exit 0
## ################## ##
## #    E X I T     # ##
## ################## ##
