------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-variable.adb,v 1.11 2004/06/28 04:57:05 vagul Exp $

with OCI.Lib;
with OCI.Thread;
with System;

package body OCI.Thick.Variable is

   use Lib;

   use type Sb4;

   ----------
   -- Bind --
   ----------

   procedure Bind
     (Stmt  : in     Statement;
      Value : in out Var_Type;
      Name  : in     String)
   is
      Rc : SWord
        := OCIBindByName
             (stmtp       => OCIStmt (Handle (Stmt)),
              bindpp      => Value.Bind'Access,
              errhp       => Thread.Error,
              placeholder => C.To_C (Name),
              placeh_len  => Name'Length,
              valuep      => Value.Value'Address,
              value_sz    => Value.Value'Size / System.Storage_Unit,
              dty         => Value.Type_Id,
              indp        => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Bind;

   procedure Bind
     (Stmt     : in     Statement;
      Value    : in out Var_Type;
      Position : in     Positive)
   is
      Rc : SWord := OCIBindByPos
           (stmtp    => OCIStmt (Handle (Stmt)),
            bindpp   => Value.Bind'Access,
            errhp    => Thread.Error,
            Position => Ub4 (Position),
            valuep   => Value.Value'Address,
            value_sz => Value.Value'Size / System.Storage_Unit,
            dty      => Value.Type_Id,
            indp     => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Bind;

   ------------
   -- Define --
   ------------

   procedure Define
     (Stmt     : in     Statement;
      Value    : in out Var_Type;
      Position : in     Positive)
   is
      Rc : SWord := OCIDefineByPos
          (stmtp    => OCIStmt (Handle (Stmt)),
           defnpp   => Value.Define'Access,
           errhp    => Thread.Error,
           position => Ub4 (Position),
           value    => Value.Value'Address,
           value_sz => Value.Value'Size / System.Storage_Unit,
           dty      => Value.Type_Id,
           indp     => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Define;

   ---------------
   -- Get_Value --
   ---------------

   function Get_Value
     (Var     : in Var_Type;
      Default : in Variable_Type;
      Mode    : in Default_Mode := Instead_Any)
      return  Variable_Type is
   begin
      if not Is_Attached (Var) then
         if Mode = Instead_Not_Attached or Mode = Instead_Any then
            return Default;
         else
            raise Not_Attached;
         end if;
      elsif Is_Null (Var) then
         if Mode = Instead_Null or Mode = Instead_Any then
            return Default;
         else
            raise Null_Value;
         end if;
      else
         return Var.Value;
      end if;
   end Get_Value;

   function Get_Value (Var : Var_Type) return Variable_Type is
   begin
      if Is_Null (Var) then
         raise Null_Value;
      else
         return Var.Value;
      end if;
   end Get_Value;

   ------------------------
   -- Get_Value_Internal --
   ------------------------

   function Get_Value_Internal (Var : Var_Type) return Variable_Type is
   begin
      return Var.Value;
   end Get_Value_Internal;

   ---------------
   -- Set_Value --
   ---------------

   procedure Set_Value (Var : in out Var_Type; Value : Variable_Type) is
   begin
      Var.Indicator := 0;
      Var.Value     := Value;
   end Set_Value;

end OCI.Thick.Variable;
