-----------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-variable.ads,v 1.7 2004/06/28 04:57:05 vagul Exp $

with OCI.Thick.Statements;

generic
   type Variable_Type is private;
package OCI.Thick.Variable is

   use OCI.Thick.Statements;

   type Default_Mode is (Instead_Null, Instead_Not_Attached, Instead_Any);

   type Var_Type (Type_Id : Ub2) is new Limited_Variable with private;

   procedure Bind
     (Stmt  : in     Statement;
      Value : in out Var_Type;
      Name  : in     String);

   procedure Bind
     (Stmt     : in     Statement;
      Value    : in out Var_Type;
      Position : in     Positive);

   procedure Define
     (Stmt     : in     Statement;
      Value    : in out Var_Type;
      Position : in     Positive);

   procedure Set_Value (Var : in out Var_Type; Value : in Variable_Type);

   function Get_Value (Var : Var_Type) return Variable_Type;

   function Value (Var : Var_Type) return Variable_Type renames Get_Value;

   function Get_Value
     (Var     : in Var_Type;
      Default : in Variable_Type;
      Mode    : in Default_Mode := Instead_Any)
      return  Variable_Type;

   function Get_Value_Internal (Var : Var_Type) return Variable_Type;

private

   pragma Inline (Get_Value_Internal);

   type Var_Type (Type_Id : Ub2) is new Limited_Variable with record
      Value : Variable_Type;
   end record;

end OCI.Thick.Variable;
