-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui.adb,v $
--  Description     : Build the IDE GUI
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/01 08:47:14 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with Ada.Text_Io;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;
with Ada.Strings;              use Ada.Strings;
with Ada.Strings.Fixed;        use Ada.Strings.Fixed;

-- GTK Support packages (gtkada package)

with Gtk.Box;                  use Gtk.Box;
with Gtk.Notebook;             use Gtk.Notebook;

-- GSQL Support packages

with Gui_Files;                use GUI_Files;
with GUI_Result;               use GUI_Result;
with GUI_Editor;               use GUI_Editor;
with GUI_Preferences;          use GUI_Preferences;
with GUI_Logging;              use GUI_Logging;
with GUI_Menu;                 use GUI_Menu;
with GUI_Tools;                use GUI_Tools;
with GUI_Table;                use GUI_Table;
with GUI_Worksheet;            use GUI_Worksheet;

with Contents_Manager.GUI;     use Contents_Manager.GUI;


package body GUI is

   --- *********************************************************************** --
   --- ***                L O C A L   D A T A    TYPES                     *** --
   --- *********************************************************************** --

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize(
      Wbox : in out Gtk_Box ) is
      -- setup the GUI windows
      Hbox, Vbox     : Gtk_Box;
      Workspace      : Gtk_Notebook;
      Preferences    : GUI_Preferences.Object;
      Pref_Title     : constant Unbounded_String := To_Unbounded_String("Preferences");
   begin
      ---------------------
      -- Add the Menubar --
      ---------------------
      GUI_Menu.Add_Menubar(Wbox);

      ---------------------
      -- Add the toolbar --
      ---------------------
      Add_Toolbar(Wbox);

      Gtk_New_Hbox (HBox, Homogeneous => False, Spacing => 3);
      Pack_Start(Wbox, Child => Hbox);
      Add_Status( Wbox );
      GUI_Logging.Active_Database( "no database connected" );

      -- create a vertical packer
      Gtk_New_Vbox (Vbox, Homogeneous => False, Spacing => 0);

      ------------------------------------
      -- create the work space notebook --
      ------------------------------------
      Gtk_New (Workspace);
      Pack_Start(Vbox, Child => Workspace);

      GUI_Result.Toplevel      := Workspace;
      GUI_Tools.Toplevel       := Workspace;
      GUI_Worksheet.Toplevel   := Workspace;

      GUI_Worksheet.Add_Sheet( Preferences, null, Pref_Title, Permanent => True );

      ---------------------
      -- Add the logging --
      ---------------------
      Add_Logging( Vbox );

      -------------------------------
      -- Add the table of contents --
      -------------------------------
      Show_Table_Of_Contents(Hbox);
      Pack_Start(HBox, VBox );

   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize(
      Wbox : in out Gtk_Box ) is
   begin
      null;
   end Finalize;

end GUI;

