-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/dbi/adbc/gnu-db-adbc-driver-pgsql.ads,v $
--  Description     : Ada Database Object - PostgreSQL Driver                --
--  Author          : Michael Erdmann                                        --
--  Created         : 18.2.2002                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/02/21 20:30:55 $
--  Version         : $Revision: 1.2 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2002 Julio Cano                                            --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This is the test driver for the ADO interface. It is some kind of        --
--  stub which simulates the requested funtions.                             --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  Only Linux                                                               --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--           julius_bib@yahoo.com                                            --
--                                                                           --
-------------------------------------------------------------------------------

package GNU.DB.ADBC.Driver.PgSQL is

   type Object is new Driver.Object with private;

   function Create return Driver.Handle ;


private
   type Object_Data;
   type Object_Data_Access is access Object_Data;

   type Object is new Driver.Object with record
         Data : Object_Data_Access;
      end record;

   procedure Prepare(
      This : in out Object;
      Stmt : in Statement_ID);

   procedure Execute_Statement(
      This   : in Object;
      Result : in Resultset_ID;
      Stmt   : in Statement_ID );

   function Create_Statement(
      This : in Object;
      Con  : in Connection_ID ) return Statement_ID;

   procedure Delete_Statement(
      This : in Object;
      Stmt : in Statement_ID );

   function Create_Resultset(
      This   : in Object;
      Stmt   : in Statement_ID ) return Resultset_ID;

   procedure Delete_Resultset(
      This   : in Object;
      Result : in Resultset_ID );

   procedure Connect(
      This     : in out Object;
      User     : in String;
      Password : in String;
      Database : in String);

   procedure Disconnect(
      This : in out Object );

   function Expand(
      This   : in Object;
      V      : in Hostvariable.Handle ) return String;

   procedure Bind_Host_Variable(
      This   : in Object;
      Stmt   : in Statement_ID;
      V      : in Hostvariable.Handle);

   procedure Get_Host_Value(
      This : in Object;
      Stmt : in Statement_ID;
      V    : in Hostvariable.Handle);

end GNU.DB.ADBC.Driver.PgSQL;

