/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_FILTERBAR_H
#define GNOME_APT_FILTERBAR_H

#include "gnome-apt.h"

#include "filter.h"

class GAptFilterBar : public Filter::View {
public:
  GAptFilterBar(Filter* filter);
  virtual ~GAptFilterBar();

  GtkWidget* widget();

  void filter_changed();

private:
  Filter* filter_;

  GtkWidget* bar_;
  
  friend void sections_toggled(GtkWidget* menuitem, gpointer data);
  friend void priority_toggled(GtkWidget* menuitem, gpointer data);
  friend void status_toggled  (GtkWidget* menuitem, gpointer data);
  friend void priority_reverse(GtkWidget* menuitem, gpointer data);
  friend void priority_clear  (GtkWidget* menuitem, gpointer data);
  friend void status_reverse  (GtkWidget* menuitem, gpointer data);
  friend void status_clear    (GtkWidget* menuitem, gpointer data);
  friend void all_reverse     (GtkWidget* menuitem, gpointer data);
  friend void all_clear       (GtkWidget* menuitem, gpointer data);
  

  void status_toggled  (GtkWidget* w);
  void priority_toggled(GtkWidget* w);

  void status_reverse  (GtkWidget* w);
  void status_clear    (GtkWidget* w);

  void priority_reverse(GtkWidget* w);
  void priority_clear  (GtkWidget* w);

  void all_reverse     (GtkWidget* w);
  void all_clear       (GtkWidget* w);

  map<GtkWidget*,Util::StatusType> statuses_;
  map<GtkWidget*,pkgCache::State::VerPriority> priorities_;

  // the standard don't-invoke-callbacks-when-we-are-the-ones-
  //  changing-state bool. used for both "we're changing the
  //  widgets" and "we're changing the filter and filter_changed
  //  should not happen"
  bool changing_state_; 
};

#endif
