/* gnome-drud-page.h
 * Copyright (C) 1999  Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GNOME_DRUD_PAGE_H__
#define __GNOME_DRUD_PAGE_H__

#include <gtk/gtk.h>

BEGIN_GNOME_DECLS

#define GNOME_TYPE_DRUD_PAGE			(gnome_drud_page_get_type ())
#define GNOME_DRUD_PAGE(obj)			(GTK_CHECK_CAST ((obj), GNOME_TYPE_DRUD_PAGE, GnomeDrudPage))
#define GNOME_DRUD_PAGE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_DRUD_PAGE, GnomeDrudPageClass))
#define GNOME_IS_DRUD_PAGE(obj)		(GTK_CHECK_TYPE ((obj), GNOME_TYPE_DRUD_PAGE))
#define GNOME_IS_DRUD_PAGE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), GNOME_TYPE_DRUD_PAGE))


typedef struct _GnomeDrudPage       GnomeDrudPage;
typedef struct _GnomeDrudPageClass  GnomeDrudPageClass;

struct _GnomeDrudPage
{
	GtkBin parent;
};
struct _GnomeDrudPageClass
{
	GtkBinClass parent_class;

	gboolean (*next)	(GnomeDrudPage *drud_page, GtkWidget *drud);
	void     (*prepare)	(GnomeDrudPage *drud_page, GtkWidget *drud);
	gboolean (*back)	(GnomeDrudPage *drud_page, GtkWidget *drud);
	void     (*finish)	(GnomeDrudPage *drud_page, GtkWidget *drud);
	void     (*cancel)	(GnomeDrudPage *drud_page, GtkWidget *drud);
};


GtkType  gnome_drud_page_get_type (void);
gboolean gnome_drud_page_next     (GnomeDrudPage *drud_page);
void     gnome_drud_page_prepare  (GnomeDrudPage *drud_page);
gboolean gnome_drud_page_back     (GnomeDrudPage *drud_page);
gboolean gnome_drud_page_cancel   (GnomeDrudPage *drud_page);
void     gnome_drud_page_finish   (GnomeDrudPage *drud_page);

END_GNOME_DECLS

#endif /* __GNOME_DRUD_PAGE_H__ */




