/* gnome-drud.h
 * Copyright (C) 1999  Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GNOME_DRUD_H__
#define __GNOME_DRUD_H__

#include <gtk/gtk.h>
#include "gnome-drud-page.h"
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GNOME_TYPE_DRUD			(gnome_drud_get_type ())
#define GNOME_DRUD(obj)			(GTK_CHECK_CAST ((obj), GNOME_TYPE_DRUD, GnomeDrud))
#define GNOME_DRUD_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_DRUD, GnomeDrudClass))
#define GNOME_IS_DRUD(obj)			(GTK_CHECK_TYPE ((obj), GNOME_TYPE_DRUD))
#define GNOME_IS_DRUD_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GNOME_TYPE_DRUD))


typedef struct _GnomeDrud       GnomeDrud;
typedef struct _GnomeDrudClass  GnomeDrudClass;

struct _GnomeDrud
{
	GtkContainer parent;
	GtkWidget *back;
	GtkWidget *next;
	GtkWidget *cancel;
	GtkWidget *finish;

	/*< private >*/
	GnomeDrudPage *current;
	GList *children;
	gboolean show_finish; /* if TRUE, then we are showing the finish button instead of the next button */
};
struct _GnomeDrudClass
{
	GtkContainerClass parent_class;
	
	void     (*cancel)	(GnomeDrud *drud);
};


GtkType    gnome_drud_get_type              (void);
GtkWidget *gnome_drud_new                   (void);
void	   gnome_drud_set_buttons_sensitive (GnomeDrud *drud,
					      gboolean back_sensitive,
					      gboolean next_sensitive,
					      gboolean cancel_sensitive);
void	   gnome_drud_set_show_finish       (GnomeDrud *drud, gboolean show_finish);
void       gnome_drud_prepend_page          (GnomeDrud *drud, GnomeDrudPage *page);
void       gnome_drud_insert_page           (GnomeDrud *drud, GnomeDrudPage *back_page, GnomeDrudPage *page);
void       gnome_drud_append_page           (GnomeDrud *drud, GnomeDrudPage *page);
void	   gnome_drud_set_page              (GnomeDrud *drud, GnomeDrudPage *page);

END_GNOME_DECLS

#endif /* __GNOME_DRUD_H__ */
