/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_PKGLIST_H
#define GNOME_APT_PKGLIST_H

#include "gnome-apt.h"
#include "pkgtree.h"
#include "infopanes.h"
#include "filterbar.h"
#include "details.h"

class GAptPkgList {
public:
  GAptPkgList(GAptPkgTree* tree, GnomeAppBar* bar);
  ~GAptPkgList();

  GtkWidget* widget() { return paned_; }

  GAptPkgTree* tree() { return tree_; }

  Filter* filter() { return filter_; }

  void set_selection(pkgCache::Package* pkg);

  pkgCache::Package* get_selection() { return selection_; }

  // Preferences
  void set_info_hidden(bool state);
  bool get_info_hidden() { return info_->get_hidden(); }

  // Menu items
  void install();
  void remove();
  void keep();
  void details();
  void search();

private:
  GtkWidget*   paned_;
  
  // bottom pane (tree)
  GAptPkgTree* tree_;
  GtkWidget* table_;
  GtkWidget* tree_frame_;

  // top pane (info/description)
  GAptInfoPanes* info_;

  // Filter
  Filter*        filter_;
  GAptFilterBar* filterbar_;

  pkgCache::Package* selection_;

  // Details window
  Details details_;
};


#endif
