/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4:ts=4:
 *
 * Gnome Apt GtkTreeModel implementation
 *
 * 	(C) 2002 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#include <glib.h>
#include <glib-object.h>

#ifndef _GAPT_TREE_MODEL_H
#define _GAPT_TREE_MODEL_H

G_BEGIN_DECLS

#define GAPT_TYPE_TREE_MODEL           (gapt_tree_model_get_type())
#define GAPT_TREE_MODEL(obj)           G_TYPE_CHECK_INSTANCE_CAST((obj), gapt_tree_model_get_type(), GAptTreeModel)
#define GAPT_TREE_MODEL_CONST(obj)     G_TYPE_CHECK_INSTANCE_CAST((obj), gapt_tree_model_get_type(), GAptTreeModel const)
#define GAPT_TREE_MODEL_CLASS(klass)   G_TYPE_CHECK_CLASS_CAST((klass), gapt_tree_model_get_type(), GAptTreeModelClass)
#define GAPT_IS_TREE_MODEL(obj)        G_TYPE_CHECK_INSTANCE_TYPE((obj), gapt_tree_model_get_type ())
#define GAPT_TREE_MODEL_GET_CLASS(obj) G_TYPE_INSTANCE_GET_CLASS((obj), gapt_tree_model_get_type(), GAptTreeModelClass)

typedef struct _GAptTreeModel GAptTreeModel;
typedef struct _GAptTreeModelClass GAptTreeModelClass;
typedef struct _GAptTreeModelPrivate GAptTreeModelPrivate;

struct _GAptTreeModel {
	GObject pobject;

	GAptTreeModelPrivate* _priv;
};

struct _GAptTreeModelClass {
	GObjectClass pclass;
};

typedef struct _GtkTreePath GtkTreePath;
typedef struct _GtkTreeModel GtkTreeModel;

GType gapt_tree_model_get_type (void);
GtkTreeModel* gapt_tree_model_new (GtkTreeModel*, GtkTreePath*);

G_END_DECLS

#endif
