/**
 * vim: sw=4 ts=4:
 *
 * Gnome Apt package cache view/controller
 *
 * 	(C) 2003, 2004 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef _CACHECONTROL_H
#define _CACHECONTROL_H

#include <gtk/gtkwidget.h>

#include "cache.h"

class pkgPackageManager;

G_BEGIN_DECLS

#define GAPT_CACHE_CONTROL_TYPE	(gapt_cache_control_get_type())
#define GAPT_CACHE_CONTROL(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), GAPT_CACHE_CONTROL_TYPE, GAptCacheControl))
#define GAPT_CACHE_CONTROL_CLASS(klass) \
      (G_TYPE_CHECK_CLASS_CAST ((klass), GAPT_CACHE_CONTROL_TYPE, GAptObjectClass))
#define IS_GAPT_CACHE_CONTROL(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAPT_CACHE_CONTROL_TYPE))
#define IS_GAPT_CACHE_CONTROL_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GAPT_CACHE_CONTROL_TYPE))

typedef struct _GAptCacheControl GAptCacheControl;
typedef struct _GAptCacheControlClass GAptCacheControlClass;
typedef struct _GAptCacheControlPrivate GAptCacheControlPrivate;

struct _GAptCacheControl {
	GObject obj;

	GAptCacheControlPrivate* priv;
};

struct _GAptCacheControlClass {
	GObjectClass parent_class;
};

GType gapt_cache_control_get_type (void);
GObject* gapt_cache_control_new (GAptCacheFile*);

GtkWidget* gapt_cache_control_pending (GAptCacheControl*);
void gapt_cache_control_smart_mark_upgrades (GAptCacheControl*);
gboolean gapt_cache_control_check (GAptCacheControl*, gchar*);	 /* Check for broken packages */
gboolean gapt_cache_control_complete (GAptCacheControl*);	/* Complete run */
gboolean gapt_cache_control_update (GAptCacheControl*);

gboolean gapt_cache_control_install_package (GAptCacheControl*, pkgCache::Package*);
void gapt_cache_control_remove_package (GAptCacheControl*, pkgCache::Package*);

G_END_DECLS

#endif
