/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt package installation handler
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003-2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_CHILD_PROCESS_H
#define GNOME_APT_CHILD_PROCESS_H

#include <gtk/gtkwidget.h>

typedef struct _GAptCacheControl GAptCacheControl;
class pkgPackageManager;

class ChildDialog {
/* Ugh... this class would better be converted into a gobject so it can emit it's own signals */
friend bool gapt_cache_control_install (GAptCacheControl*, pkgPackageManager*);
public:
	ChildDialog (const char*, const char*);
	~ChildDialog (void);

	gint child_died (gint, gint);
	int fork (void);
	gint run (void);
	void feed (const gchar*);

private:
  GtkWidget* dialog_;
  GtkWidget* term_;
  GtkWidget* label_;
  bool we_are_parent_;

	bool child_done_;
	gint pid;
	gint res;

	static gint close_cb (GtkWidget*, gpointer);
	gint close (void);
};

#endif
