/**
 * vim: sw=4 ts=4:
 *
 * GKeyFile based GnomeConfig substitute
 *
 *	(C) 2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_CONFFILE_H
#define GNOME_APT_CONFFILE_H

#include <glib.h>

typedef const gchar* gcharp;
typedef gsize* gsizep;

class ConfFile {
public:
	ConfFile (const gchar*, gboolean=FALSE);
	~ConfFile (void);

	void save (const gchar*) const;
	void sync (void) const;

	void clean_section (const gchar*) const;

	gboolean get_bool (const gchar*, const gchar*, gboolean=FALSE) const;
	gint get_integer (const gchar*, const gchar*, gint=0) const;
	gchar** get_keys (const gchar*, gsizep=NULL) const;
	gchar* get_string (const gchar*, const gchar*, gcharp=NULL) const;

	void set_bool (const gchar*, const gchar*, const gboolean);
	void set_integer (const gchar*, const gchar*, const gint);
	void set_string (const gchar*, const gchar*, const gchar*);
private:
	GKeyFile* kf;
	gchar* loadpath;
};

#endif /* GNOME_APT_CONFFILE_H */
