/**
 * vim: sw=4 ts=4:
 *
 * Gnome Apt common header
 *
 * 	(C) 2003-2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef _GADEFS_H
#define _GADEFS_H

#include "config.h"
#include <glib/gi18n.h>

#ifndef _
#if ENABLE_NLS
#define _(x) gettext(x)
#define gettext_noop(x) (x)
#define N_(x) gettext_noop(x)
#else
#define _(x) (x)
#define N_(x) (x)
#endif
#endif

#define GAPT_PAD 6
#define GAPT_PAD_SMALL 4
#define GAPT_PAD_BIG 12

#ifdef GNOME_ENABLE_DEBUG
#ifdef __GNUC__
#define	ga_debug(format, args...) \
	g_log (G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, format, ##args)
#else	/* !__GNUC__ */
static inline void
ga_debug (const gchar *format, ...) {
	va_list args;
	va_start (args, format);
	g_logv (G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, format, args);
	va_end (args);
}
#endif	/* !__GNUC__ */

#else	/* !GNOME_ENABLE_DEBUG */
#ifdef __GNUC__
#define ga_debug(format, args...)
#else
static inline void ga_debug (const gchar* format, ...) {}
#endif	/* !GNUC */
#endif	/* !GNOME_ENABLE_DEBUG */

#endif
