/**
 * vim: sw=4 ts=4:
 *
 * Derived GtkDrawingArea, with an expander_size property.
 *
 * 	(C) 2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef _GAPT_DRAWING_AREA_H
#define _GAPT_DRAWING_AREA_H

#include <gtk/gtkdrawingarea.h>

G_BEGIN_DECLS

#define GAPT_DRAWING_AREA_TYPE	(gapt_drawing_area_get_type())
#define GAPT_DRAWING_AREA(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), GAPT_DRAWING_AREA_TYPE, GAptDrawingArea))
#define GAPT_DRAWING_AREA_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GAPT_DRAWING_AREA_TYPE, GAptDrawingAreaClass))
#define IS_GAPT_DRAWING_AREA(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAPT_DRAWING_AREA_TYPE))
#define IS_GAPT_DRAWING_AREA_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GAPT_DRAWING_AREA_TYPE))

typedef struct _GAptDrawingArea GAptDrawingArea;
typedef struct _GAptDrawingAreaClass GAptDrawingAreaClass;

struct _GAptDrawingArea {
	GtkDrawingArea da;
};

struct _GAptDrawingAreaClass {
	GtkDrawingAreaClass parent_class;

	void (*selection_changed) (GAptDrawingArea*);
	void (*details_hidden) (GAptDrawingArea*);
	void (*details_shown) (GAptDrawingArea*);
};

GType gapt_drawing_area_get_type (void);
GtkWidget* gapt_drawing_area_new (void);

G_END_DECLS
#endif
