/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"


GtkWidget*
create_cvs_commit_dialog (void)
{
	GtkWidget *cvs_commit_dialog;
	GtkWidget *dialog_vbox3;
	GtkWidget *vbox1;
	GtkWidget *frame2;
	GtkWidget *scrolledwindow4;
	GtkWidget *file_clist;
	GtkWidget *label3;
	GtkWidget *frame1;
	GtkWidget *scrolledwindow3;
	GtkWidget *msg_text;
	GtkWidget *dialog_action_area3;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;

	cvs_commit_dialog = gnome_dialog_new (_("CVS commit"), NULL);
	gtk_object_set_data (GTK_OBJECT (cvs_commit_dialog), "cvs_commit_dialog", cvs_commit_dialog);
	gtk_widget_set_usize (cvs_commit_dialog, 300, 200);

	dialog_vbox3 = GNOME_DIALOG (cvs_commit_dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (cvs_commit_dialog), "dialog_vbox3", dialog_vbox3);
	gtk_widget_show (dialog_vbox3);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "vbox1", vbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox3), vbox1, TRUE, TRUE, 0);

	frame2 = gtk_frame_new (_("Files to commit"));
	gtk_widget_ref (frame2);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "frame2", frame2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame2);
	gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 0);

	scrolledwindow4 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow4);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "scrolledwindow4", scrolledwindow4,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow4);
	gtk_container_add (GTK_CONTAINER (frame2), scrolledwindow4);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow4), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	file_clist = gtk_clist_new (1);
	gtk_widget_ref (file_clist);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "file_clist", file_clist,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (file_clist);
	gtk_container_add (GTK_CONTAINER (scrolledwindow4), file_clist);
	gtk_clist_set_column_width (GTK_CLIST (file_clist), 0, 80);
	gtk_clist_column_titles_hide (GTK_CLIST (file_clist));

	label3 = gtk_label_new ("label3");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "label3", label3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_clist_set_column_widget (GTK_CLIST (file_clist), 0, label3);

	frame1 = gtk_frame_new (_("Enter log message"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "frame1", frame1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);

	scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow3);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "scrolledwindow3", scrolledwindow3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow3);
	gtk_container_add (GTK_CONTAINER (frame1), scrolledwindow3);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	msg_text = gtk_text_new (NULL, NULL);
	gtk_widget_ref (msg_text);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "msg_text", msg_text,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (msg_text);
	gtk_container_add (GTK_CONTAINER (scrolledwindow3), msg_text);

	dialog_action_area3 = GNOME_DIALOG (cvs_commit_dialog)->action_area;
	gtk_object_set_data (GTK_OBJECT (cvs_commit_dialog), "dialog_action_area3", dialog_action_area3);
	gtk_widget_show (dialog_action_area3);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_SPREAD);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area3), 8);

	gnome_dialog_append_button (GNOME_DIALOG (cvs_commit_dialog), GNOME_STOCK_BUTTON_OK);
	ok_button = g_list_last (GNOME_DIALOG (cvs_commit_dialog)->buttons)->data;
	gtk_widget_ref (ok_button);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "ok_button", ok_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ok_button);
	GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (cvs_commit_dialog), GNOME_STOCK_BUTTON_CANCEL);
	cancel_button = g_list_last (GNOME_DIALOG (cvs_commit_dialog)->buttons)->data;
	gtk_widget_ref (cancel_button);
	gtk_object_set_data_full (GTK_OBJECT (cvs_commit_dialog), "cancel_button", cancel_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cancel_button);
	GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

	return cvs_commit_dialog;
}

