/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_CVS_SERVER_H__
#define __GNOME_CMD_CVS_SERVER_H__



typedef struct _GnomeCmdCvsServer GnomeCmdCvsServer;
typedef struct _GnomeCmdCvsServerPrivate GnomeCmdCvsServerPrivate;

struct _GnomeCmdCvsServer {
	GnomeCmdCvsServerPrivate *priv;
};


GnomeCmdCvsServer*
gnome_cmd_cvs_server_new                 (void);

GnomeCmdCvsServer*
gnome_cmd_cvs_server_new_with_values     (gchar *alias, gchar *string);

void
gnome_cmd_cvs_server_free                (GnomeCmdCvsServer *fs);

void
gnome_cmd_cvs_server_ref                 (GnomeCmdCvsServer *fs);

void
gnome_cmd_cvs_server_unref               (GnomeCmdCvsServer *fs);

void
gnome_cmd_cvs_server_set_alias           (GnomeCmdCvsServer *fs,
										  gchar *alias);

void
gnome_cmd_cvs_server_set_string          (GnomeCmdCvsServer *fs,
										  gchar *string);

gchar*
gnome_cmd_cvs_server_get_alias           (GnomeCmdCvsServer *fs); 

gchar*
gnome_cmd_cvs_server_get_string          (GnomeCmdCvsServer *fs);


#endif //__GNOME_CMD_CVS_SERVER_H__
