/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_FILE_FUNCS_H__
#define __GNOME_CMD_FILE_FUNCS_H__

GnomeCmdFile *gnome_cmd_file_new (void);
GnomeCmdFile *gnome_cmd_file_new_with_values (GnomeVFSFileInfo *info, GnomeCmdDir *dir);

void gnome_cmd_file_ref (GnomeCmdFile *file);
void gnome_cmd_file_unref (GnomeCmdFile *file);

void gnome_cmd_file_add_observer (GnomeCmdFile *file,
								  GnomeCmdFileUpdateCallbackFunc func,
								  gpointer user_data);
void gnome_cmd_file_remove_observer (GnomeCmdFile *file,
									 GnomeCmdFileUpdateCallbackFunc func,
									 gpointer user_data);

GnomeVFSResult gnome_cmd_file_chmod (GnomeCmdFile *file, GnomeVFSFilePermissions perm);
GnomeVFSResult gnome_cmd_file_chown (GnomeCmdFile *file, uid_t uid, gid_t gid);

const gchar *gnome_cmd_file_get_name (GnomeCmdFile *file);
const gchar *gnome_cmd_file_get_owner (GnomeCmdFile *file);
const gchar *gnome_cmd_file_get_group (GnomeCmdFile *file);
const gchar *gnome_cmd_file_get_date (GnomeCmdFile *file);
const gchar *gnome_cmd_file_get_size (GnomeCmdFile *file);
const gchar *gnome_cmd_file_get_perm (GnomeCmdFile *file);
const gchar *gnome_cmd_file_get_path (GnomeCmdFile *file);
GnomeVFSURI *gnome_cmd_file_get_uri (GnomeCmdFile *file);
const gchar *gnome_cmd_file_get_uri_str (GnomeCmdFile *file);
const gchar *gnome_cmd_file_get_mime_type (GnomeCmdFile *file);

const gchar *gnome_cmd_file_get_type_string (GnomeCmdFile *finfo);
const gchar *gnome_cmd_file_get_type_desc (GnomeCmdFile *finfo);
GdkPixmap *gnome_cmd_file_get_type_pixmap_small (GnomeCmdFile *finfo);
GdkPixmap *gnome_cmd_file_get_type_pixmap_big (GnomeCmdFile *finfo);
GdkBitmap *gnome_cmd_file_get_type_mask_small (GnomeCmdFile *finfo);
GdkBitmap *gnome_cmd_file_get_type_mask_big (GnomeCmdFile *finfo);

void gnome_cmd_file_show_properties (GnomeCmdFile *finfo);
void gnome_cmd_file_show_chown_dialog (GList *files);
void gnome_cmd_file_show_chmod_dialog (GList *files);
void gnome_cmd_file_view (GnomeCmdFile *finfo);
void gnome_cmd_file_edit (GnomeCmdFile *finfo);
void gnome_cmd_file_delete (GList *files);
void gnome_cmd_file_show_cap_cut (GnomeCmdFile *finfo);
void gnome_cmd_file_show_cap_copy (GnomeCmdFile *finfo);
void gnome_cmd_file_show_cap_paste (GnomeCmdFile *finfo);

GList *gnome_cmd_file_list_copy (GList *files);
void gnome_cmd_file_list_free (GList *files);
void gnome_cmd_file_list_ref (GList *files);
void gnome_cmd_file_list_unref (GList *files);

void gnome_cmd_file_update_info (GnomeCmdFile *finfo, GnomeVFSFileInfo *info);

#endif // __GNOME_CMD_FILE_FUNCS_H__
