/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"


struct _GnomeCmdMkdirDialogPrivate
{
	GnomeCmdDir *dir;
	GnomeCmdMainWin *mw;
};


static GnomeCmdStringDialogClass *parent_class = NULL;



static void
on_ok (const gchar *string, GnomeCmdMkdirDialog *dialog)
{
	GnomeVFSURI *uri;
	GnomeVFSResult result;

	/* dont create any directory if no name was passed or cancel was selected */
	if (string == NULL || strcmp (string, "") == 0)
		return;

	uri = gnome_cmd_dir_get_file_uri (dialog->priv->dir, string);

	result = gnome_vfs_make_directory_for_uri (
		uri,
		GNOME_VFS_PERM_USER_READ|GNOME_VFS_PERM_USER_WRITE|GNOME_VFS_PERM_USER_EXEC|
		GNOME_VFS_PERM_GROUP_READ|GNOME_VFS_PERM_GROUP_EXEC|
		GNOME_VFS_PERM_OTHER_READ|GNOME_VFS_PERM_OTHER_EXEC);

	gnome_vfs_uri_unref (uri);
	
	if (result != GNOME_VFS_OK)
		create_error_dialog (gnome_vfs_result_to_string (result));

	gnome_cmd_dir_unref (dialog->priv->dir);
}


static void
on_cancel (GtkWidget *widget, GnomeCmdMkdirDialog *dialog)
{
	gnome_cmd_dir_unref (dialog->priv->dir);
}


/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	GnomeCmdMkdirDialog *dialog = GNOME_CMD_MKDIR_DIALOG (object);

	g_free (dialog->priv);
	
	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}


static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdMkdirDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_cmd_string_dialog_get_type ());
	object_class->destroy = destroy;
	widget_class->map = map;
}


static void
init (GnomeCmdMkdirDialog *dialog)
{
	dialog->priv = g_new (GnomeCmdMkdirDialogPrivate, 1);
}




/***********************************
 * Public functions
 ***********************************/

GtkWidget*
gnome_cmd_mkdir_dialog_new (GnomeCmdDir *dir)
{	
	GnomeCmdMkdirDialog *dialog = gtk_type_new (gnome_cmd_mkdir_dialog_get_type ());

	dialog->priv->dir = dir;
	gnome_cmd_dir_ref (dir);
	
	gnome_cmd_string_dialog_set_title (GNOME_CMD_STRING_DIALOG (dialog), _("Make directory"));
	gnome_cmd_string_dialog_set_prompt (GNOME_CMD_STRING_DIALOG (dialog), _("Enter a name for the new directory"));
	gnome_cmd_string_dialog_set_pixmap (GNOME_CMD_STRING_DIALOG (dialog), PIXMAP_MKDIR);
	gnome_cmd_string_dialog_set_ok_cb (GNOME_CMD_STRING_DIALOG (dialog), (GnomeStringCallback)on_ok);
	gnome_cmd_string_dialog_set_cancel_cb (GNOME_CMD_STRING_DIALOG (dialog), (GnomeStringCallback)on_cancel);
	gnome_cmd_string_dialog_set_userdata (GNOME_CMD_STRING_DIALOG (dialog), dialog);
	
	return GTK_WIDGET (dialog);
}



GtkType
gnome_cmd_mkdir_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdMkdirDialog",
			sizeof (GnomeCmdMkdirDialog),
			sizeof (GnomeCmdMkdirDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_cmd_string_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}



