/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"

static GnomeDialogClass *parent_class = NULL;



struct _GnomeCmdOptionsDialogPrivate
{
	GnomeCmdMainWin *mw;
};


static void
on_options_tab_use_mime_toggle      (GtkToggleButton *button,
										 gpointer user_data)
{
	GtkWidget *mime_frame = lookup_widget (GTK_WIDGET (button), "mime_frame");

	gtk_widget_set_sensitive (mime_frame,
							  gtk_toggle_button_get_active (button));
}


/* store options */
static void
store_hide_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *hide_unknown_check;
	GtkWidget *hide_directory_check;
	GtkWidget *hide_regular_check;
	GtkWidget *hide_socket_check;
	GtkWidget *hide_fifo_check;
	GtkWidget *hide_block_check;
	GtkWidget *hide_char_check;
	GtkWidget *hide_hidden_check;
	GtkWidget *hide_symlink_check;

	hide_unknown_check = lookup_widget (GTK_WIDGET (dialog), "hide_unknown_check");
	hide_regular_check = lookup_widget (GTK_WIDGET (dialog), "hide_regular_check");
	hide_directory_check = lookup_widget (GTK_WIDGET (dialog), "hide_directory_check");
	hide_fifo_check = lookup_widget (GTK_WIDGET (dialog), "hide_fifo_check");
	hide_socket_check = lookup_widget (GTK_WIDGET (dialog), "hide_socket_check");
	hide_char_check = lookup_widget (GTK_WIDGET (dialog), "hide_char_check");
	hide_block_check = lookup_widget (GTK_WIDGET (dialog), "hide_block_check");
	hide_symlink_check = lookup_widget (GTK_WIDGET (dialog), "hide_symlink_check");
	hide_hidden_check = lookup_widget (GTK_WIDGET (dialog), "hide_hidden_check");
	
	gnome_cmd_data_set_type_filter (
		GNOME_VFS_FILE_TYPE_UNKNOWN,
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_unknown_check)));

	gnome_cmd_data_set_type_filter (
		GNOME_VFS_FILE_TYPE_REGULAR,
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_regular_check)));
	
	gnome_cmd_data_set_type_filter (
		GNOME_VFS_FILE_TYPE_DIRECTORY,
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_directory_check)));
	
	gnome_cmd_data_set_type_filter (
		GNOME_VFS_FILE_TYPE_FIFO,
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_fifo_check)));
	
	gnome_cmd_data_set_type_filter (
		GNOME_VFS_FILE_TYPE_SOCKET,
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_socket_check)));
	
	gnome_cmd_data_set_type_filter (
		GNOME_VFS_FILE_TYPE_CHARACTER_DEVICE,
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_char_check)));
	
	gnome_cmd_data_set_type_filter (
		GNOME_VFS_FILE_TYPE_BLOCK_DEVICE,
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_block_check)));
	
	gnome_cmd_data_set_type_filter (
		GNOME_VFS_FILE_TYPE_SYMBOLIC_LINK,
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_symlink_check)));
	
	gnome_cmd_data_set_hidden_filter (
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hide_hidden_check)));
}


static void
store_layout_options (GnomeCmdOptionsDialog *dialog)
{
	GnomeCmdLayoutColors *colors = gnome_cmd_data_get_layout_colors ();
	GtkWidget *gfx_text_radio;
	GtkWidget *size_powered_radio, *size_grouped_radio;
	GtkWidget *norm_fg, *norm_bg;
	GtkWidget *sel_fg, *sel_bg;
	GtkWidget *curs_fg, *curs_bg;
	GtkWidget *term_fg, *term_bg;
	GtkWidget *font_picker;
	GtkWidget *term_scale;
	gushort a = 0;
	gchar *font;

	gfx_text_radio = lookup_widget (GTK_WIDGET (dialog), "gfx_text_radio");
	size_powered_radio = lookup_widget (GTK_WIDGET (dialog), "size_powered_radio");
	size_grouped_radio = lookup_widget (GTK_WIDGET (dialog), "size_grouped_radio");
	norm_fg = lookup_widget (GTK_WIDGET (dialog), "default_fg");
	norm_bg = lookup_widget (GTK_WIDGET (dialog), "default_bg");
	sel_fg = lookup_widget (GTK_WIDGET (dialog), "selected_fg");
	sel_bg = lookup_widget (GTK_WIDGET (dialog), "selected_bg");
	curs_fg = lookup_widget (GTK_WIDGET (dialog), "cursor_fg");
	curs_bg = lookup_widget (GTK_WIDGET (dialog), "cursor_bg");
	term_fg = lookup_widget (GTK_WIDGET (dialog), "term_fg");
	term_bg = lookup_widget (GTK_WIDGET (dialog), "term_bg");
	font_picker = lookup_widget (GTK_WIDGET (dialog), "font_picker");
	term_scale = lookup_widget (GTK_WIDGET (dialog), "term_scale");

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gfx_text_radio)))
		gnome_cmd_data_set_layout (GNOME_CMD_LAYOUT_TEXT);
	else
		gnome_cmd_data_set_layout (GNOME_CMD_LAYOUT_ICONS);

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (size_powered_radio)))
		gnome_cmd_data_set_size_disp_mode (GNOME_CMD_SIZE_DISP_MODE_POWERED);
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (size_grouped_radio)))
		gnome_cmd_data_set_size_disp_mode (GNOME_CMD_SIZE_DISP_MODE_GROUPED);
	else
		gnome_cmd_data_set_size_disp_mode (GNOME_CMD_SIZE_DISP_MODE_PLAIN);

	font = gnome_font_picker_get_font_name (GNOME_FONT_PICKER (font_picker));
	if (strcmp (font, "default") != 0)
		gnome_cmd_data_set_font (font);

	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (norm_fg),
		&colors->norm_fg->red, &colors->norm_fg->green, &colors->norm_fg->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (norm_bg),
		&colors->norm_bg->red, &colors->norm_bg->green, &colors->norm_bg->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (sel_fg),
		&colors->sel_fg->red, &colors->sel_fg->green, &colors->sel_fg->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (sel_bg),
		&colors->sel_bg->red, &colors->sel_bg->green, &colors->sel_bg->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (curs_fg),
		&colors->curs_fg->red, &colors->curs_fg->green, &colors->curs_fg->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (curs_bg),
		&colors->curs_bg->red, &colors->curs_bg->green, &colors->curs_bg->blue, &a);	
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (term_fg),
		&colors->term_fg->red, &colors->term_fg->green, &colors->term_fg->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (term_bg),
		&colors->term_bg->red, &colors->term_bg->green, &colors->term_bg->blue, &a);	

	{
		GtkAdjustment *adj = gtk_range_get_adjustment (GTK_RANGE (term_scale));
		gnome_cmd_data_set_embterm_height (adj->value);
	}
}


static void
store_sort_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *case_sens_check = lookup_widget (GTK_WIDGET (dialog), "case_sens_check");

	gnome_cmd_data_set_case_sens_sort (
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (case_sens_check)));
}


static void
store_date_format_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *entry = lookup_widget (GTK_WIDGET (dialog),
									  "date_format_entry");
	
	if (GTK_IS_ENTRY (entry))
	{
		gchar *format = gtk_entry_get_text (GTK_ENTRY (entry));
		gnome_cmd_data_set_date_format (format);
	}
}

/*
static void
store_cvs_options (GnomeCmdOptionsDialog *dialog)
{
	gchar *tmp;
	GnomeCmdCvsUpdateColors *colors  = gnome_cmd_data_get_cvs_update_colors ();
	GtkWidget *modified = lookup_widget (GTK_WIDGET (dialog), "modified");
	GtkWidget *updated = lookup_widget (GTK_WIDGET (dialog), "updated");
	GtkWidget *unknown = lookup_widget (GTK_WIDGET (dialog), "unknown");
	GtkWidget *added = lookup_widget (GTK_WIDGET (dialog), "added");
	GtkWidget *removed = lookup_widget (GTK_WIDGET (dialog), "removed");
	GtkWidget *conflict = lookup_widget (GTK_WIDGET (dialog), "conflict");
	GtkWidget *ssh_check = lookup_widget (GTK_WIDGET (dialog), "ssh_check");
	GtkWidget *cvsroot_entry = lookup_widget (GTK_WIDGET (dialog), "cvsroot_entry");
	gushort a = 0;

	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (modified),
		&colors->modified->red, &colors->modified->green, &colors->modified->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (updated),
        &colors->updated->red, &colors->updated->green, &colors->updated->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (unknown),
        &colors->unknown->red, &colors->unknown->green, &colors->unknown->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (added),
        &colors->added->red, &colors->added->green, &colors->added->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (removed),
        &colors->removed->red, &colors->removed->green, &colors->removed->blue, &a);
	gnome_color_picker_get_i16 (
		GNOME_COLOR_PICKER (conflict),
        &colors->conflict->red, &colors->conflict->green, &colors->conflict->blue, &a);

	tmp = gtk_entry_get_text (GTK_ENTRY (cvsroot_entry));
	gnome_cmd_data_set_cvsroot (tmp);

	gnome_cmd_data_set_cvs_over_ssh (
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ssh_check)));
}
*/
/*
static void
store_ftp_options (GnomeCmdOptionsDialog *dialog)
{
}
*/

static void
store_external_programs_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *entry1 = lookup_widget (GTK_WIDGET (dialog), "viewer");
	GtkWidget *entry2 = lookup_widget (GTK_WIDGET (dialog), "editor");
	GtkWidget *entry3 = lookup_widget (GTK_WIDGET (dialog), "differ");
	GtkWidget *entry4 = lookup_widget (GTK_WIDGET (dialog), "cvs_differ");
	GtkWidget *entry5 = lookup_widget (GTK_WIDGET (dialog), "term");

	gnome_cmd_data_set_viewer (gtk_entry_get_text (GTK_ENTRY (entry1)));
	gnome_cmd_data_set_editor (gtk_entry_get_text (GTK_ENTRY (entry2)));
	gnome_cmd_data_set_differ (gtk_entry_get_text (GTK_ENTRY (entry3)));
	gnome_cmd_data_set_cvs_differ (gtk_entry_get_text (GTK_ENTRY (entry4)));
	gnome_cmd_data_set_term (gtk_entry_get_text (GTK_ENTRY (entry5)));
}


static void
store_options_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *rmb_popup_radio = lookup_widget (GTK_WIDGET (dialog), "rmb_popup_radio");
	GtkWidget *mime_check = lookup_widget (GTK_WIDGET (dialog), "mime_check");
	GtkWidget *iconsize_scale = lookup_widget (GTK_WIDGET (dialog), "iconsize_scale");
	GtkWidget *iconquality_scale = lookup_widget (GTK_WIDGET (dialog), "iconquality_scale");
	GtkWidget *icondir_entry = lookup_widget (GTK_WIDGET (dialog), "icondir_entry");

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rmb_popup_radio)))
		gnome_cmd_data_set_right_mouse_button_mode(RIGHT_BUTTON_POPUPS_MENU);
	else
		gnome_cmd_data_set_right_mouse_button_mode(RIGHT_BUTTON_SELECTS);

	gnome_cmd_data_set_use_mime (
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (mime_check)));

	gnome_cmd_data_set_mime_icon_dir (
		gtk_entry_get_text (GTK_ENTRY (icondir_entry)));

	{
		GtkAdjustment *adj;
		adj = gtk_range_get_adjustment (GTK_RANGE (iconsize_scale));
		gnome_cmd_data_set_mime_icon_size (adj->value);
		adj = gtk_range_get_adjustment (GTK_RANGE (iconquality_scale));
		gnome_cmd_data_set_mime_scale_quality (adj->value);
	}
}


/* load options */
static void
load_hide_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *hide_unknown_check;
	GtkWidget *hide_regular_check;
	GtkWidget *hide_directory_check;
	GtkWidget *hide_fifo_check;
	GtkWidget *hide_socket_check;
	GtkWidget *hide_char_check;
	GtkWidget *hide_block_check;
	GtkWidget *hide_symlink_check;
	GtkWidget *hide_hidden_check;

	hide_unknown_check = lookup_widget (GTK_WIDGET (dialog), "hide_unknown_check");
	hide_regular_check = lookup_widget (GTK_WIDGET (dialog), "hide_regular_check");
	hide_directory_check = lookup_widget (GTK_WIDGET (dialog), "hide_directory_check");
	hide_fifo_check = lookup_widget (GTK_WIDGET (dialog), "hide_fifo_check");
	hide_socket_check = lookup_widget (GTK_WIDGET (dialog), "hide_socket_check");
	hide_char_check = lookup_widget (GTK_WIDGET (dialog), "hide_char_check");
	hide_block_check = lookup_widget (GTK_WIDGET (dialog), "hide_block_check");
	hide_symlink_check = lookup_widget (GTK_WIDGET (dialog), "hide_symlink_check");
	hide_hidden_check = lookup_widget (GTK_WIDGET (dialog), "hide_hidden_check");

	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_unknown_check),
		gnome_cmd_data_get_type_filter (GNOME_VFS_FILE_TYPE_UNKNOWN));
	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_regular_check),
		gnome_cmd_data_get_type_filter (GNOME_VFS_FILE_TYPE_REGULAR));
	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_directory_check),
		gnome_cmd_data_get_type_filter (GNOME_VFS_FILE_TYPE_DIRECTORY));
	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_fifo_check),
		gnome_cmd_data_get_type_filter (GNOME_VFS_FILE_TYPE_FIFO));
	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_socket_check),
		gnome_cmd_data_get_type_filter (GNOME_VFS_FILE_TYPE_SOCKET));
	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_char_check),
		gnome_cmd_data_get_type_filter (GNOME_VFS_FILE_TYPE_CHARACTER_DEVICE));
	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_block_check),
		gnome_cmd_data_get_type_filter (GNOME_VFS_FILE_TYPE_BLOCK_DEVICE));
	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_symlink_check),
		gnome_cmd_data_get_type_filter (GNOME_VFS_FILE_TYPE_SYMBOLIC_LINK));
	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (hide_hidden_check),
		gnome_cmd_data_get_hidden_filter ());
}


static void
load_layout_options (GnomeCmdOptionsDialog *dialog)
{
	GnomeCmdLayoutColors *colors = gnome_cmd_data_get_layout_colors ();
	GtkWidget *gfx_text_radio, *gfx_icons_radio;
	GtkWidget *size_powered_radio, *size_grouped_radio, *size_plain_radio;
	GtkWidget *norm_fg, *norm_bg;
	GtkWidget *sel_fg, *sel_bg;
	GtkWidget *curs_fg, *curs_bg;
	GtkWidget *term_fg, *term_bg;
	GtkWidget *font_picker;
	GtkWidget *term_scale;
	gushort a = 0;


	gfx_text_radio = lookup_widget (GTK_WIDGET (dialog), "gfx_text_radio");
	gfx_icons_radio = lookup_widget (GTK_WIDGET (dialog), "gfx_icons_radio");

	size_powered_radio = lookup_widget (GTK_WIDGET (dialog), "size_powered_radio");
	size_grouped_radio = lookup_widget (GTK_WIDGET (dialog), "size_grouped_radio");
	size_plain_radio = lookup_widget (GTK_WIDGET (dialog), "size_plain_radio");

	norm_fg = lookup_widget (GTK_WIDGET (dialog), "default_fg");
	norm_bg = lookup_widget (GTK_WIDGET (dialog), "default_bg");
	sel_fg = lookup_widget (GTK_WIDGET (dialog), "selected_fg");
	sel_bg = lookup_widget (GTK_WIDGET (dialog), "selected_bg");
	curs_fg = lookup_widget (GTK_WIDGET (dialog), "cursor_fg");
	curs_bg = lookup_widget (GTK_WIDGET (dialog), "cursor_bg");
	term_fg = lookup_widget (GTK_WIDGET (dialog), "term_fg");
	term_bg = lookup_widget (GTK_WIDGET (dialog), "term_bg");

	font_picker = lookup_widget (GTK_WIDGET (dialog), "font_picker");
	term_scale = lookup_widget (GTK_WIDGET (dialog), "term_scale");
	
	if (gnome_cmd_data_get_layout () == GNOME_CMD_LAYOUT_TEXT)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gfx_text_radio), TRUE);
	else
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gfx_icons_radio), TRUE);

	if (gnome_cmd_data_get_size_disp_mode () == GNOME_CMD_SIZE_DISP_MODE_POWERED)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (size_powered_radio), TRUE);
	else if (gnome_cmd_data_get_size_disp_mode () == GNOME_CMD_SIZE_DISP_MODE_GROUPED)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (size_grouped_radio), TRUE);
	else
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (size_plain_radio), TRUE);

	gnome_font_picker_set_font_name (
		GNOME_FONT_PICKER (font_picker),
		gnome_cmd_data_get_font ());
	gnome_font_picker_set_preview_text (
		GNOME_FONT_PICKER (font_picker),
		"Default preview text provided for your convenience :)");
	{
		GtkAdjustment *adj = gtk_range_get_adjustment (GTK_RANGE (term_scale));
		adj->value = gnome_cmd_data_get_embterm_height ();
	}
	
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (norm_fg),
		colors->norm_fg->red, colors->norm_fg->green, colors->norm_fg->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (norm_bg),
		colors->norm_bg->red, colors->norm_bg->green, colors->norm_bg->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (sel_fg),
		colors->sel_fg->red, colors->sel_fg->green, colors->sel_fg->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (sel_bg),
		colors->sel_bg->red, colors->sel_bg->green, colors->sel_bg->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (curs_fg),
		colors->curs_fg->red, colors->curs_fg->green, colors->curs_fg->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (curs_bg),
		colors->curs_bg->red, colors->curs_bg->green, colors->curs_bg->blue, a);	
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (term_fg),
		colors->term_fg->red, colors->term_fg->green, colors->term_fg->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (term_bg),
		colors->term_bg->red, colors->term_bg->green, colors->term_bg->blue, a);	
}


static void
load_sort_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *case_sens_check = lookup_widget (GTK_WIDGET (dialog), "case_sens_check");

	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (case_sens_check),
		gnome_cmd_data_get_case_sens_sort ());
}


static void
load_dates_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *entry = lookup_widget (GTK_WIDGET (dialog),
									  "date_format_entry");
	
	if (GTK_IS_ENTRY (entry))
	{
		gtk_entry_set_text (
			GTK_ENTRY (entry),
			gnome_cmd_data_get_date_format ());
	}
}

/*
static void
load_cvs_options (GnomeCmdOptionsDialog *dialog)
{
	GnomeCmdCvsUpdateColors *colors  = gnome_cmd_data_get_cvs_update_colors ();
	GtkWidget *modified = lookup_widget (GTK_WIDGET (dialog), "modified");
	GtkWidget *updated = lookup_widget (GTK_WIDGET (dialog), "updated");
	GtkWidget *unknown = lookup_widget (GTK_WIDGET (dialog), "unknown");
	GtkWidget *added = lookup_widget (GTK_WIDGET (dialog), "added");
	GtkWidget *removed = lookup_widget (GTK_WIDGET (dialog), "removed");
	GtkWidget *conflict = lookup_widget (GTK_WIDGET (dialog), "conflict");
	GtkWidget *ssh_check = lookup_widget (GTK_WIDGET (dialog), "ssh_check");
	GtkWidget *cvsroot_entry = lookup_widget (GTK_WIDGET (dialog), "cvsroot_entry");
	gushort a = 0;

	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (modified),
		colors->modified->red, colors->modified->green, colors->modified->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (updated),
        colors->updated->red, colors->updated->green, colors->updated->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (unknown),
        colors->unknown->red, colors->unknown->green, colors->unknown->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (added),
        colors->added->red, colors->added->green, colors->added->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (removed),
        colors->removed->red, colors->removed->green, colors->removed->blue, a);
	gnome_color_picker_set_i16 (
		GNOME_COLOR_PICKER (conflict),
        colors->conflict->red, colors->conflict->green, colors->conflict->blue, a);

	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (ssh_check),
		gnome_cmd_data_get_cvs_over_ssh ());

	gtk_entry_set_text (
		GTK_ENTRY (cvsroot_entry),
		gnome_cmd_data_get_cvsroot ());
}
*/
/*
static void
load_ftp_options (GnomeCmdOptionsDialog *dialog)
{
}
*/

static void
load_external_programs_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *entry1 = lookup_widget (GTK_WIDGET (dialog), "viewer");
	GtkWidget *entry2 = lookup_widget (GTK_WIDGET (dialog), "editor");
	GtkWidget *entry3 = lookup_widget (GTK_WIDGET (dialog), "differ");
	GtkWidget *entry4 = lookup_widget (GTK_WIDGET (dialog), "cvs_differ");
	GtkWidget *entry5 = lookup_widget (GTK_WIDGET (dialog), "term");

	gtk_entry_set_text (GTK_ENTRY (entry1), gnome_cmd_data_get_viewer ());
	gtk_entry_set_text (GTK_ENTRY (entry2), gnome_cmd_data_get_editor ());
	gtk_entry_set_text (GTK_ENTRY (entry3), gnome_cmd_data_get_differ ());
	gtk_entry_set_text (GTK_ENTRY (entry4), gnome_cmd_data_get_cvs_differ ());
	gtk_entry_set_text (GTK_ENTRY (entry5), gnome_cmd_data_get_term ());
}


static void
load_options_options (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *rmb_popup_radio = lookup_widget (GTK_WIDGET (dialog), "rmb_popup_radio");
	GtkWidget *rmb_sel_radio = lookup_widget (GTK_WIDGET (dialog), "rmb_sel_radio");
	GtkWidget *mime_check = lookup_widget (GTK_WIDGET (dialog), "mime_check");
	GtkWidget *mime_frame = lookup_widget (GTK_WIDGET (dialog), "mime_frame");
	GtkWidget *iconsize_scale = lookup_widget (GTK_WIDGET (dialog), "iconsize_scale");
	GtkWidget *iconquality_scale = lookup_widget (GTK_WIDGET (dialog), "iconquality_scale");
	GtkWidget *icondir_entry = lookup_widget (GTK_WIDGET (dialog), "icondir_entry");

	if (gnome_cmd_data_get_right_mouse_button_mode() == RIGHT_BUTTON_POPUPS_MENU)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rmb_popup_radio), TRUE);
	else
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rmb_sel_radio), TRUE);

	gtk_toggle_button_set_active (
		GTK_TOGGLE_BUTTON (mime_check),
		gnome_cmd_data_get_use_mime ());
	gtk_widget_set_sensitive (mime_frame, gnome_cmd_data_get_use_mime ());

	gtk_entry_set_text (
		GTK_ENTRY (icondir_entry),
		gnome_cmd_data_get_mime_icon_dir ());

	{
		GtkAdjustment *adj;

		adj = gtk_range_get_adjustment (GTK_RANGE (iconsize_scale));
		adj->value = gnome_cmd_data_get_mime_icon_size ();
		adj = gtk_range_get_adjustment (GTK_RANGE (iconquality_scale));
		adj->value = gnome_cmd_data_get_mime_scale_quality ();
	}
}



static void
on_date_format_update                    (GtkButton       *button,
										  gpointer         user_data)
{
    char *format;
	char s[256];
    time_t t;
    struct tm *lt;

    GtkWidget *format_entry, *test_label;
	GtkWidget *options_dialog = GTK_WIDGET (user_data);

    format_entry = lookup_widget (options_dialog, "date_format_entry");
    test_label = lookup_widget (options_dialog, "date_format_test_label");
	
    t = time (NULL);
    lt = localtime (&t);
    format = gtk_entry_get_text (GTK_ENTRY (format_entry));

    strftime (s, 256, format, lt);

    gtk_label_set_text (GTK_LABEL (test_label), s);	
}


static void
on_ok_btn_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	if (GNOME_IS_CMD_OPTIONS_DIALOG (user_data))
	{
		GnomeCmdOptionsDialog *dialog = GNOME_CMD_OPTIONS_DIALOG (user_data);
		
		store_hide_options (dialog);
		store_layout_options (dialog);
		store_sort_options (dialog);
		store_date_format_options (dialog);
//		store_cvs_options (dialog);
//		store_ftp_options (dialog);
		store_external_programs_options (dialog);
		store_options_options (dialog);

		gtk_widget_hide (GTK_WIDGET (dialog));


		gnome_cmd_style_create ();
		gnome_cmd_main_win_update_style (dialog->priv->mw);
	}
}


static void
on_cancel_btn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	if (GTK_IS_WIDGET (user_data))
		gtk_widget_hide (GTK_WIDGET (user_data));
}








/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	GnomeCmdOptionsDialog *dialog = GNOME_CMD_OPTIONS_DIALOG (object);

	g_free (dialog->priv);

	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdOptionsDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_dialog_get_type ());

	object_class->destroy = destroy;

	widget_class->map = map;
}


static GtkWidget*
create_hide_tab (GtkWidget *options_dialog)
{
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *vbox3;
	GtkWidget *frame1;
	GtkWidget *frame2;

	GtkWidget *hide_unknown_check;
	GtkWidget *hide_directory_check;
	GtkWidget *hide_regular_check;
	GtkWidget *hide_socket_check;
	GtkWidget *hide_fifo_check;
	GtkWidget *hide_block_check;
	GtkWidget *hide_char_check;
	GtkWidget *hide_hidden_check;
	GtkWidget *hide_symlink_check;


	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox1", vbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);

	
	frame1 = gtk_frame_new (_("Filetypes to hide"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame1", frame1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (vbox1), frame1, FALSE, TRUE, 2);

	
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox2", vbox2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (frame1), vbox2);

	
	hide_unknown_check = gtk_check_button_new_with_label (_("Unknown"));
	gtk_widget_ref (hide_unknown_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_unknown_check", hide_unknown_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_unknown_check);
	gtk_box_pack_start (GTK_BOX (vbox2), hide_unknown_check, FALSE, FALSE, 0);


	hide_regular_check = gtk_check_button_new_with_label (_("Regular files"));
	gtk_widget_ref (hide_regular_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_regular_check", hide_regular_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_regular_check);
	gtk_box_pack_start (GTK_BOX (vbox2), hide_regular_check, FALSE, FALSE, 0);

	
	hide_directory_check = gtk_check_button_new_with_label (_("Directories"));
	gtk_widget_ref (hide_directory_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_directory_check", hide_directory_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_directory_check);
	gtk_box_pack_start (GTK_BOX (vbox2), hide_directory_check, FALSE, FALSE, 0);

	
	hide_fifo_check = gtk_check_button_new_with_label (_("Fifo files"));
	gtk_widget_ref (hide_fifo_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_fifo_check", hide_fifo_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_fifo_check);
	gtk_box_pack_start (GTK_BOX (vbox2), hide_fifo_check, FALSE, FALSE, 0);


	hide_socket_check = gtk_check_button_new_with_label (_("Socket files"));
	gtk_widget_ref (hide_socket_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_socket_check", hide_socket_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_socket_check);
	gtk_box_pack_start (GTK_BOX (vbox2), hide_socket_check, FALSE, FALSE, 0);

	
	hide_char_check = gtk_check_button_new_with_label (_("Character devices"));
	gtk_widget_ref (hide_char_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_char_check", hide_char_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_char_check);
	gtk_box_pack_start (GTK_BOX (vbox2), hide_char_check, FALSE, FALSE, 0);

	
	hide_block_check = gtk_check_button_new_with_label (_("Block devices"));
	gtk_widget_ref (hide_block_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_block_check", hide_block_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_block_check);
	gtk_box_pack_start (GTK_BOX (vbox2), hide_block_check, FALSE, FALSE, 0);

	
	frame2 = gtk_frame_new (_("Also hide"));
	gtk_widget_ref (frame2);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame2", frame2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame2);
	gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 2);

	
	vbox3 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox3", vbox3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_container_add (GTK_CONTAINER (frame2), vbox3);

	
	hide_hidden_check = gtk_check_button_new_with_label (_("Hidden files"));
	gtk_widget_ref (hide_hidden_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_hidden_check", hide_hidden_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_hidden_check);
	gtk_box_pack_start (GTK_BOX (vbox3), hide_hidden_check, FALSE, FALSE, 0);

	
	hide_symlink_check = gtk_check_button_new_with_label (_("Symlinks"));
	gtk_widget_ref (hide_symlink_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "hide_symlink_check", hide_symlink_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hide_symlink_check);
	gtk_box_pack_start (GTK_BOX (vbox3), hide_symlink_check, FALSE, FALSE, 0);

	
	return vbox1;
}


static GtkWidget*
create_layout_tab (GtkWidget *options_dialog)
{
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *hbox2;
	GtkWidget *vbox2;
	GtkWidget *vbox3;
	GtkWidget *frame1;
	GtkWidget *frame2;
	GtkWidget *frame3;
	GtkWidget *frame4;
	GtkWidget *frame5;
	GtkWidget *table;
	GtkWidget *gfx_icons_radio;
	GtkWidget *gfx_text_radio;
	GSList    *vbox2_group = NULL;
	GSList    *vbox3_group = NULL;
	GtkWidget *size_powered_radio;
	GtkWidget *size_grouped_radio;
	GtkWidget *size_plain_radio;
	GtkWidget *default_fg;
	GtkWidget *default_bg;
	GtkWidget *selected_fg;
	GtkWidget *selected_bg;
	GtkWidget *cursor_fg;
	GtkWidget *cursor_bg;
	GtkWidget *term_fg;
	GtkWidget *term_bg;
	GtkWidget *label;
	GtkWidget *font_picker;
	GtkWidget *term_scale;

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox1", vbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "hbox1", hbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

	frame1 = gtk_frame_new (_("Graphical mode"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame1", frame1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (hbox1), frame1, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox2", vbox2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (frame1), vbox2);

	gfx_icons_radio =
		gtk_radio_button_new_with_label (vbox2_group, _("icons"));
	vbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (gfx_icons_radio));
	gtk_widget_ref (gfx_icons_radio);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "gfx_icons_radio", gfx_icons_radio,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gfx_icons_radio);
	gtk_box_pack_start (GTK_BOX (vbox2), gfx_icons_radio, FALSE, FALSE, 0);

	gfx_text_radio = gtk_radio_button_new_with_label (vbox2_group, _("text"));
	vbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (gfx_text_radio));
	gtk_widget_ref (gfx_text_radio);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "gfx_text_radio", gfx_text_radio,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gfx_text_radio);
	gtk_box_pack_start (GTK_BOX (vbox2), gfx_text_radio, FALSE, FALSE, 0);

	frame2 = gtk_frame_new (_("Size display mode"));
	gtk_widget_ref (frame2);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame2", frame2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame2);
	gtk_box_pack_start (GTK_BOX (hbox1), frame2, TRUE, TRUE, 0);

	vbox3 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox3", vbox3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_container_add (GTK_CONTAINER (frame2), vbox3);

	size_powered_radio = gtk_radio_button_new_with_label (
		vbox3_group, _("powered (ex 1.53 M)"));
	vbox3_group = gtk_radio_button_group (
		GTK_RADIO_BUTTON (size_powered_radio));
	gtk_widget_ref (size_powered_radio);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "size_powered_radio", size_powered_radio,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (size_powered_radio);
	gtk_box_pack_start (GTK_BOX (vbox3), size_powered_radio, FALSE, FALSE, 0);

	size_grouped_radio = gtk_radio_button_new_with_label (
		vbox3_group, _("grouped (ex 1,600,000)"));
	vbox3_group = gtk_radio_button_group (
		GTK_RADIO_BUTTON (size_grouped_radio));
	gtk_widget_ref (size_grouped_radio);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "size_grouped_radio", size_grouped_radio,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (size_grouped_radio);
	gtk_box_pack_start (GTK_BOX (vbox3), size_grouped_radio, FALSE, FALSE, 0);

	size_plain_radio = gtk_radio_button_new_with_label (
		vbox3_group, _("plain (ex 1600000)"));
	vbox3_group = gtk_radio_button_group (GTK_RADIO_BUTTON (size_plain_radio));
	gtk_widget_ref (size_plain_radio);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "size_plain_radio", size_plain_radio,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (size_plain_radio);
	gtk_box_pack_start (GTK_BOX (vbox3), size_plain_radio, FALSE, FALSE, 0);

	
	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "hbox2", hbox2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);

	/* The font picker and its frame
	 *
	 */
	frame4 = gtk_frame_new (_("Font"));
	gtk_widget_ref (frame4);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame4", frame4,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame4);
	gtk_box_pack_start (GTK_BOX (hbox2), frame4, TRUE, TRUE, 0);

	font_picker = gnome_font_picker_new ();
	gtk_widget_ref (font_picker);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "font_picker", font_picker,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (font_picker);
	gtk_container_add (GTK_CONTAINER (frame4), font_picker);	

	/* The embedded terminal height scale and its frame
	 *
	 */
	frame5 = gtk_frame_new (_("Embedded terminal height"));
	gtk_widget_ref (frame5);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame5", frame5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame5);
	gtk_box_pack_start (GTK_BOX (hbox2), frame5, TRUE, TRUE, 0);

	term_scale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (
		gnome_cmd_data_get_embterm_height(),
		1, 20,
		0, 0, 0)));
	gtk_scale_set_digits (GTK_SCALE (term_scale), 0);
	gtk_widget_ref (term_scale);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "term_scale", term_scale,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (term_scale);
	gtk_container_add (GTK_CONTAINER (frame5), term_scale);	

	/* The color pickers
	 *
	 */
	frame3 = gtk_frame_new (_("Colors"));
	gtk_widget_ref (frame3);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame3", frame3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame3);
	gtk_box_pack_start (GTK_BOX (vbox1), frame3, TRUE, TRUE, 0);

	table = gtk_table_new (4, 3, TRUE);
	gtk_widget_ref (table);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "table", table,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table);
	gtk_container_add (GTK_CONTAINER (frame3), table);
	gtk_table_set_row_spacings (GTK_TABLE (table), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table), 12);

	default_fg = gnome_color_picker_new ();
	gtk_widget_ref (default_fg);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "default_fg", default_fg,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (default_fg);
	gtk_table_attach (GTK_TABLE (table), default_fg, 1, 2, 1, 2,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	default_bg = gnome_color_picker_new ();
	gtk_widget_ref (default_bg);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "default_bg", default_bg,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (default_bg);
	gtk_table_attach (GTK_TABLE (table), default_bg, 2, 3, 1, 2,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	selected_fg = gnome_color_picker_new ();
	gtk_widget_ref (selected_fg);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "selected_fg", selected_fg,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (selected_fg);
	gtk_table_attach (GTK_TABLE (table), selected_fg, 1, 2, 2, 3,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	selected_bg = gnome_color_picker_new ();
	gtk_widget_ref (selected_bg);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "selected_bg", selected_bg,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (selected_bg);
	gtk_table_attach (GTK_TABLE (table), selected_bg, 2, 3, 2, 3,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	cursor_fg = gnome_color_picker_new ();
	gtk_widget_ref (cursor_fg);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "cursor_fg", cursor_fg,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cursor_fg);
	gtk_table_attach (GTK_TABLE (table), cursor_fg, 1, 2, 3, 4,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	cursor_bg = gnome_color_picker_new ();
	gtk_widget_ref (cursor_bg);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "cursor_bg", cursor_bg,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cursor_bg);
	gtk_table_attach (GTK_TABLE (table), cursor_bg, 2, 3, 3, 4,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	term_fg = gnome_color_picker_new ();
	gtk_widget_ref (term_fg);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "term_fg", term_fg,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (term_fg);
	gtk_table_attach (GTK_TABLE (table), term_fg, 1, 2, 4, 5,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	term_bg = gnome_color_picker_new ();
	gtk_widget_ref (term_bg);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "term_bg", term_bg,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (term_bg);
	gtk_table_attach (GTK_TABLE (table), term_bg, 2, 3, 4, 5,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	label = gtk_label_new (_("foreground"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label153", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 1, 2, 0, 1,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	label = gtk_label_new (_("background"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1,
					  (GtkAttachOptions) (0),
					  (GtkAttachOptions) (0), 0, 0);

	label = gtk_label_new (_("Default:"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label152", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 7.45058e-09, 0.5);

	label = gtk_label_new (_("Selected file:"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

	label = gtk_label_new (_("Cursor:"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 7.45058e-09, 0.5);

	label = gtk_label_new (_("Embedded terminal:"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 4, 5,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 7.45058e-09, 0.5);
	

	return vbox1;
}


static GtkWidget*
create_sort_tab (GtkWidget *options_dialog)
{
	GtkWidget *frame1;
	GtkWidget *vbox1;
	GtkWidget *case_sens_check;
	
	frame1 = gtk_frame_new (_("Options"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame1", frame1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);

	
	vbox1 = gtk_vbox_new (FALSE, 7);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox1", vbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (frame1), vbox1);

	case_sens_check = gtk_check_button_new_with_label (_("Case sensitive"));
	gtk_widget_ref (case_sens_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "case_sens_check", case_sens_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (case_sens_check);
	gtk_box_pack_start (GTK_BOX (vbox1), case_sens_check, FALSE, FALSE, 0);


 
	return frame1;
}


static GtkWidget*
create_dates_tab (GtkWidget *options_dialog)
{
	GtkWidget *frame20;
	GtkWidget *vbox15;
	GtkWidget *hbox26;
	GtkWidget *hbox27;
	GtkWidget *hbox28;
	
	GtkWidget *date_format_entry;
	GtkWidget *date_format_test_button;
	GtkWidget *date_format_test_label;

	GtkWidget *label;

	
	frame20 = gtk_frame_new (_("Dateformat string"));
	gtk_widget_ref (frame20);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame20", frame20,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame20);

	vbox15 = gtk_vbox_new (FALSE, 7);
	gtk_widget_ref (vbox15);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox15", vbox15,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox15);
	gtk_container_add (GTK_CONTAINER (frame20), vbox15);

	hbox27 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox27);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "hbox27", hbox27,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox27);
	gtk_box_pack_start (GTK_BOX (vbox15), hbox27, FALSE, TRUE, 5);

	label = gtk_label_new (_("format:"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox27), label, FALSE, FALSE, 2);
	gtk_widget_set_usize (label, 41, 16);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label), 5, 0);

	hbox28 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox28);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "hbox28", hbox28,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox28);
	gtk_box_pack_start (GTK_BOX (hbox27), hbox28, TRUE, TRUE, 0);

	date_format_entry = gtk_entry_new ();
	gtk_widget_ref (date_format_entry);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "date_format_entry", date_format_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (date_format_entry);
	gtk_box_pack_start (GTK_BOX (hbox28), date_format_entry, TRUE, TRUE, 2);
	gtk_widget_set_usize (date_format_entry, 168, 22);

	date_format_test_button = gtk_button_new_with_label (_("Test"));
	gtk_widget_ref (date_format_test_button);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "date_format_test_button",
							  date_format_test_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (date_format_test_button);
	gtk_box_pack_start (GTK_BOX (hbox28), date_format_test_button,
						FALSE, FALSE, 5);
	gtk_widget_set_usize (date_format_test_button, 40, 24);

	hbox26 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox26);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "hbox26", hbox26,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox26);
	gtk_box_pack_start (GTK_BOX (vbox15), hbox26, FALSE, TRUE, 4);

	label = gtk_label_new (_("test:"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox26), label, FALSE, FALSE, 2);
	gtk_widget_set_usize (label, 41, 16);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label), 5, 0);

	date_format_test_label = gtk_label_new (_("2000-11-10 13:50"));
	gtk_widget_ref (date_format_test_label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "date_format_test_label", date_format_test_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (date_format_test_label);
	gtk_box_pack_start (GTK_BOX (hbox26), date_format_test_label,
						FALSE, FALSE, 2);
	gtk_widget_set_usize (date_format_test_label, 208, 16);
	gtk_misc_set_alignment (GTK_MISC (date_format_test_label), 0.0, 0.5);

	label = gtk_label_new (_("See the manual page for \"strftime\" for help on \nhow to set the format string."));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (vbox15), label, FALSE, FALSE, 3);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label), 5, 14);


	gtk_widget_grab_focus (date_format_entry);	
	
	gtk_signal_connect (GTK_OBJECT (date_format_test_button), "clicked",
						GTK_SIGNAL_FUNC (on_date_format_update),
						options_dialog);
	
	return frame20;
}

/*
static GtkWidget*
create_cvs_tab (GtkWidget *options_dialog)
{
	GtkWidget *root_vbox;
	GtkWidget *frame1;
	GtkWidget *frame2;
	GtkWidget *table1;
	GtkWidget *label17;
	GtkWidget *label18;
	GtkWidget *label19;
	GtkWidget *label20;
	GtkWidget *label21;
	GtkWidget *label22;
	GtkWidget *label23;
	GtkWidget *modified;
	GtkWidget *updated;
	GtkWidget *unknown;
	GtkWidget *added;
	GtkWidget *removed;
	GtkWidget *conflict;
	GtkWidget *vbox1, *hbox1;
	GtkWidget *ssh_check;
	GtkWidget *cvsroot_entry;


	
	root_vbox = gtk_vbox_new (FALSE, FALSE);
	gtk_widget_ref (root_vbox);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "root_vbox", root_vbox,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (root_vbox);


	
	frame2 = gtk_frame_new (_("Options"));
	gtk_widget_ref (frame2);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame2", frame2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (root_vbox), frame2,
						FALSE, FALSE, 1);
	gtk_widget_show (frame2);

	vbox1 = gtk_vbox_new (FALSE, FALSE);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox1", vbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_container_add (GTK_CONTAINER (frame2), vbox1);
	gtk_widget_show (vbox1);

	ssh_check = gtk_check_button_new_with_label ("Run CVS through SSH (CVS_RSH=ssh)");
	gtk_widget_ref (ssh_check);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "ssh_check", ssh_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (vbox1), ssh_check,
						FALSE, FALSE, 1);
	gtk_widget_show (ssh_check);

	hbox1 = gtk_hbox_new (FALSE, FALSE);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "hbox1", hbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1,
						FALSE, FALSE, 1);
	gtk_widget_show (hbox1);

	label23 = gtk_label_new (_("CVSROOT"));
	gtk_widget_ref (label23);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label23", label23,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (hbox1), label23,
						FALSE, FALSE, 1);
	gtk_widget_show (label23);

	cvsroot_entry = gtk_entry_new ();
	gtk_widget_ref (cvsroot_entry);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "cvsroot_entry", cvsroot_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (hbox1), cvsroot_entry,
						TRUE, TRUE, 1);						
	gtk_widget_show (cvsroot_entry);
	
	
	
	frame1 = gtk_frame_new (_("Colors in the update dialog"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame1", frame1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (root_vbox), frame1,
						FALSE, FALSE, 1);
	gtk_widget_show (frame1);

	table1 = gtk_table_new (3, 4, TRUE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "table1", table1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_container_add (GTK_CONTAINER (frame1), table1);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 4);
	gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
	gtk_table_set_col_spacings (GTK_TABLE (table1), 5);

	label17 = gtk_label_new (_("modified"));
	gtk_widget_ref (label17);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label17", label17,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label17);
	gtk_table_attach (GTK_TABLE (table1), label17, 0, 1, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label17), 0, 0.5);

	label18 = gtk_label_new (_("updated"));
	gtk_widget_ref (label18);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label18", label18,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label18);
	gtk_table_attach (GTK_TABLE (table1), label18, 0, 1, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label18), 0, 0.5);

	label19 = gtk_label_new (_("unknown"));
	gtk_widget_ref (label19);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label19", label19,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label19);
	gtk_table_attach (GTK_TABLE (table1), label19, 0, 1, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label19), 0, 0.5);

	label20 = gtk_label_new (_("added"));
	gtk_widget_ref (label20);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label20", label20,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label20);
	gtk_table_attach (GTK_TABLE (table1), label20, 2, 3, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label20), 0, 0.5);

	label21 = gtk_label_new (_("removed"));
	gtk_widget_ref (label21);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label21", label21,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label21);
	gtk_table_attach (GTK_TABLE (table1), label21, 2, 3, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label21), 0, 0.5);

	label22 = gtk_label_new (_("conflict"));
	gtk_widget_ref (label22);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "label22", label22,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label22);
	gtk_table_attach (GTK_TABLE (table1), label22, 2, 3, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label22), 0, 0.5);

	modified = gnome_color_picker_new ();
	gtk_widget_ref (modified);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "modified", modified,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (modified);
	gtk_table_attach (GTK_TABLE (table1), modified, 1, 2, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	updated = gnome_color_picker_new ();
	gtk_widget_ref (updated);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "updated", updated,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (updated);
	gtk_table_attach (GTK_TABLE (table1), updated, 1, 2, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	unknown = gnome_color_picker_new ();
	gtk_widget_ref (unknown);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "unknown", unknown,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (unknown);
	gtk_table_attach (GTK_TABLE (table1), unknown, 1, 2, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	added = gnome_color_picker_new ();
	gtk_widget_ref (added);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "added", added,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (added);
	gtk_table_attach (GTK_TABLE (table1), added, 3, 4, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	removed = gnome_color_picker_new ();
	gtk_widget_ref (removed);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "removed", removed,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (removed);
	gtk_table_attach (GTK_TABLE (table1), removed, 3, 4, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	conflict = gnome_color_picker_new ();
	gtk_widget_ref (conflict);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "conflict", conflict,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (conflict);
	gtk_table_attach (GTK_TABLE (table1), conflict, 3, 4, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	return root_vbox;
}
*/
/*
static GtkWidget*
create_ftp_tab (GtkWidget *options_dialog)
{
	GtkWidget *frame1;
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	
	frame1 = gtk_frame_new (_("Options"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "frame1", frame1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);

	
	vbox1 = gtk_vbox_new (FALSE, 7);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "vbox1", vbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (frame1), vbox1);


	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "hbox1", hbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 5);

 
	return frame1;
}
*/

static GtkWidget*
create_external_programs_tab (GtkWidget *dialog)
{
	GtkWidget *frame1;
	GtkWidget *table1;

	GtkWidget *label1, *label2, *label3, *label4, *label5;
	GtkWidget *entry1, *entry2, *entry3, *entry4, *entry5;

	frame1 = gtk_frame_new (_("External programs"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "frame1", frame1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);

	table1 = gtk_table_new (5, 2, FALSE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "table1", table1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_container_add (GTK_CONTAINER (frame1), table1);
	gtk_table_set_row_spacings (GTK_TABLE (table1), 2);
	gtk_table_set_col_spacings (GTK_TABLE (table1), 2);

	label1 = gtk_label_new (_("viewer"));
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label1", label1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

	label2 = gtk_label_new (_("editor"));
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label2", label2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

	label3 = gtk_label_new (_("differ"));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label3", label3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_table_attach (GTK_TABLE (table1), label3, 0, 1, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);

	label4 = gtk_label_new (_("CVS differ"));
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label4", label4,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_table_attach (GTK_TABLE (table1), label4, 0, 1, 3, 4,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);

	label5 = gtk_label_new (_("Terminal"));
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label5", label5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 4, 5,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.5);

	
	entry1 = gtk_entry_new ();
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "viewer", entry1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry1);
	gtk_table_attach (GTK_TABLE (table1), entry1, 1, 2, 0, 1,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	entry2 = gtk_entry_new ();
	gtk_widget_ref (entry2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "editor", entry2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry2);
	gtk_table_attach (GTK_TABLE (table1), entry2, 1, 2, 1, 2,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	entry3 = gtk_entry_new ();
	gtk_widget_ref (entry3);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "differ", entry3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry3);
	gtk_table_attach (GTK_TABLE (table1), entry3, 1, 2, 2, 3,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	entry4 = gtk_entry_new ();
	gtk_widget_ref (entry4);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "cvs_differ", entry4,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry4);
	gtk_table_attach (GTK_TABLE (table1), entry4, 1, 2, 3, 4,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	entry5 = gtk_entry_new ();
	gtk_widget_ref (entry5);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "term", entry5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry5);
	gtk_table_attach (GTK_TABLE (table1), entry5, 1, 2, 4, 5,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	
	return frame1; 
}


static GtkWidget*
create_options_tab (GtkWidget *dialog)
{
	GtkWidget *vbox;
	GtkWidget *frame1, *frame2;
	GtkWidget *vbox2;
	GSList    *vbox2_group = NULL;
	GtkWidget *rmb_sel_radio;
	GtkWidget *rmb_popup_radio;
	GtkWidget *mime_check;
	GtkWidget *iconsize_scale;
	GtkWidget *iconquality_scale;
	GtkWidget *icondir_fileentry;
	GtkWidget *icondir_entry;
	GtkWidget *label;
	GtkWidget *table;

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "vbox", vbox,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox);

	
	/* Right mouse button settings
	 */
	frame1 = gtk_frame_new (_("Use right mouse button to"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "frame1", frame1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (vbox), frame1, FALSE, FALSE, 2);
	gtk_widget_show (frame1);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "vbox2", vbox2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (frame1), vbox2);

	rmb_popup_radio = gtk_radio_button_new_with_label (vbox2_group, _("Show popup menu"));
	vbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rmb_popup_radio));
	gtk_widget_ref (rmb_popup_radio);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "rmb_popup_radio", rmb_popup_radio,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rmb_popup_radio);
	gtk_box_pack_start (GTK_BOX (vbox2), rmb_popup_radio, FALSE, FALSE, 0);
	
	rmb_sel_radio =
		gtk_radio_button_new_with_label (vbox2_group, _("Select files"));
	vbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rmb_sel_radio));
	gtk_widget_ref (rmb_sel_radio);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "rmb_sel_radio", rmb_sel_radio,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rmb_sel_radio);
	gtk_box_pack_start (GTK_BOX (vbox2), rmb_sel_radio, FALSE, FALSE, 0);

	
	/* MIME settings
	 */
	mime_check = gtk_check_button_new_with_label (_("Lookup MIME data"));
	gtk_widget_ref (mime_check);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "mime_check", mime_check,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (vbox), mime_check, FALSE, FALSE, 2);
	gtk_widget_show (mime_check);
	gtk_signal_connect (GTK_OBJECT (mime_check), "toggled",
						GTK_SIGNAL_FUNC (on_options_tab_use_mime_toggle), NULL);
	
	frame2 = gtk_frame_new (_("MIME settings"));
	gtk_widget_ref (frame2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "mime_frame", frame2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (vbox), frame2, FALSE, FALSE, 2);
	gtk_widget_show (frame2);
	
	table = gtk_table_new (3, 4, TRUE);
	gtk_widget_ref (table);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "table", table,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table);
	gtk_container_add (GTK_CONTAINER (frame2), table);
	gtk_table_set_row_spacings (GTK_TABLE (table), 2);
	gtk_table_set_col_spacings (GTK_TABLE (table), 2);
	
	iconsize_scale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (
		gnome_cmd_data_get_mime_icon_size(),
		8, 32,
		0, 0, 0)));
	gtk_scale_set_digits (GTK_SCALE (iconsize_scale), 0);
	gtk_widget_ref (iconsize_scale);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "iconsize_scale", iconsize_scale,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_table_attach (GTK_TABLE (table), iconsize_scale, 1, 4, 0, 1,
					  (GtkAttachOptions) (GTK_EXPAND|GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_show (iconsize_scale);

	iconquality_scale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (
		gnome_cmd_data_get_mime_scale_quality (),
		0, 3,
		0, 0, 0)));
	gtk_scale_set_digits (GTK_SCALE (iconquality_scale), 0);
	gtk_widget_ref (iconquality_scale);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "iconquality_scale", iconquality_scale,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_table_attach (GTK_TABLE (table), iconquality_scale, 1, 4, 1, 2,
					  (GtkAttachOptions) (GTK_EXPAND|GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_show (iconquality_scale);

	icondir_fileentry = gnome_file_entry_new (NULL, NULL);
	gtk_widget_ref (icondir_fileentry);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "icondir_fileentry", icondir_fileentry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (icondir_fileentry);
	gtk_table_attach (GTK_TABLE (table), icondir_fileentry, 1, 4, 2, 3,
					  (GtkAttachOptions) (GTK_EXPAND|GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	icondir_entry = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (icondir_fileentry));
	gtk_widget_ref (icondir_entry);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "icondir_entry", icondir_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (icondir_entry);
	
	label = gtk_label_new (_("Icon size"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
					  (GtkAttachOptions) (GTK_SHRINK),
					  (GtkAttachOptions) (0), 0, 0);
	
	label = gtk_label_new (_("Scaling quality"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
					  (GtkAttachOptions) (GTK_SHRINK),
					  (GtkAttachOptions) (0), 0, 0);

	label = gtk_label_new (_("Icon directory"));
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label", label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
					  (GtkAttachOptions) (GTK_SHRINK),
					  (GtkAttachOptions) (0), 0, 0);

	
	return vbox;
}


static void
init (GnomeCmdOptionsDialog *dialog)
{
	GtkWidget *options_dialog;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	
	dialog->priv = g_new (GnomeCmdOptionsDialogPrivate, 1);
	options_dialog = GTK_WIDGET (dialog);

	
	gtk_object_set_data (GTK_OBJECT (options_dialog), "options_dialog",
						 options_dialog);
	gtk_window_set_position (GTK_WINDOW (options_dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_modal (GTK_WINDOW (options_dialog), TRUE);
	gtk_window_set_title (GTK_WINDOW (options_dialog), _("Options"));

	
	dialog->notebook = gtk_notebook_new ();
	gtk_widget_ref (dialog->notebook);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog), "notebook",
							  dialog->notebook, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->notebook);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), dialog->notebook,
						TRUE, TRUE, 0);


	gtk_container_add (GTK_CONTAINER (dialog->notebook),
					   create_hide_tab (options_dialog));
	gtk_container_add (GTK_CONTAINER (dialog->notebook),
					   create_layout_tab (options_dialog));
	gtk_container_add (GTK_CONTAINER (dialog->notebook),
					   create_sort_tab (options_dialog));
	gtk_container_add (GTK_CONTAINER (dialog->notebook),
					   create_dates_tab (options_dialog));
//	gtk_container_add (GTK_CONTAINER (dialog->notebook),
//					   create_cvs_tab (options_dialog));
//	gtk_container_add (GTK_CONTAINER (dialog->notebook),
//					   create_ftp_tab (options_dialog));
	gtk_container_add (GTK_CONTAINER (dialog->notebook),
					   create_external_programs_tab (options_dialog));
	gtk_container_add (GTK_CONTAINER (dialog->notebook),
					   create_options_tab (options_dialog));

	
	gtk_notebook_set_tab_label (
		GTK_NOTEBOOK (dialog->notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog->notebook),
								   GNOME_CMD_OPTIONS_DIALOG_TAB_HIDE),
		gtk_label_new (_("Hide")));

	gtk_notebook_set_tab_label (
		GTK_NOTEBOOK (dialog->notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog->notebook),
								   GNOME_CMD_OPTIONS_DIALOG_TAB_LAYOUT),
		gtk_label_new (_("Layout")));

	gtk_notebook_set_tab_label (
		GTK_NOTEBOOK (dialog->notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog->notebook),
								   GNOME_CMD_OPTIONS_DIALOG_TAB_SORT),
		gtk_label_new (_("Sort")));

	gtk_notebook_set_tab_label (
		GTK_NOTEBOOK (dialog->notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog->notebook),
								   GNOME_CMD_OPTIONS_DIALOG_TAB_DATES),
		gtk_label_new (_("Dates")));
/*
	gtk_notebook_set_tab_label (
		GTK_NOTEBOOK (dialog->notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog->notebook),
								   GNOME_CMD_OPTIONS_DIALOG_TAB_CVS),
		gtk_label_new (_("CVS")));
*/
/*	
	gtk_notebook_set_tab_label (
		GTK_NOTEBOOK (dialog->notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog->notebook),
								   GNOME_CMD_OPTIONS_DIALOG_TAB_FTP),
		gtk_label_new (_("FTP")));
*/
	gtk_notebook_set_tab_label (
		GTK_NOTEBOOK (dialog->notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog->notebook),
								   GNOME_CMD_OPTIONS_DIALOG_TAB_EX_PROGS),
		gtk_label_new (_("Programs")));

	gtk_notebook_set_tab_label (
		GTK_NOTEBOOK (dialog->notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog->notebook),
								   GNOME_CMD_OPTIONS_DIALOG_TAB_OPTIONS),
		gtk_label_new (_("Options")));
	

	
	gnome_dialog_append_button (GNOME_DIALOG (options_dialog),
								GNOME_STOCK_BUTTON_OK);
	ok_button = g_list_last (GNOME_DIALOG (options_dialog)->buttons)->data;
	gtk_widget_ref (ok_button);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "ok_button", ok_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ok_button);
	GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

	
	gnome_dialog_append_button (GNOME_DIALOG (options_dialog),
								GNOME_STOCK_BUTTON_CANCEL);
	cancel_button = g_list_last (GNOME_DIALOG (options_dialog)->buttons)->data;
	gtk_widget_ref (cancel_button);
	gtk_object_set_data_full (GTK_OBJECT (options_dialog),
							  "cancel_button", cancel_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cancel_button);
	GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

	
	gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
						GTK_SIGNAL_FUNC (on_ok_btn_clicked),
						options_dialog);
	gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
						GTK_SIGNAL_FUNC (on_cancel_btn_clicked),
						options_dialog);
}




/***********************************
 * Public functions
 ***********************************/

GtkType
gnome_cmd_options_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdOptionsDialog",
			sizeof (GnomeCmdOptionsDialog),
			sizeof (GnomeCmdOptionsDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}


GtkWidget*
gnome_cmd_options_dialog_new (GnomeCmdMainWin *mw)
{	
	GnomeCmdOptionsDialog *dialog;

	dialog = gtk_type_new (gnome_cmd_options_dialog_get_type ());
	dialog->priv->mw = mw;

	load_hide_options (dialog);
	load_layout_options (dialog);
	load_sort_options (dialog);
	load_dates_options (dialog);
//	load_cvs_options (dialog);
//	load_ftp_options (dialog);
	load_external_programs_options (dialog);
	load_options_options (dialog);
	
	return GTK_WIDGET (dialog);
}


void
gnome_cmd_options_dialog_set_tab (GnomeCmdOptionsDialog *dialog, GnomeCmdOptionsDialogTab tab)
{
	gtk_notebook_set_page (GTK_NOTEBOOK (dialog->notebook), tab);
}

