/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"


typedef struct
{
	GnomeCmdDir *dir;
	GtkWidget *term_check;
} RunDialogData;


static void
on_ok (gchar *in_command, RunDialogData *data)
{
	gchar *command;	
	const gchar *dir_path;

	if (!in_command || strcmp (in_command, "") == 0)
		return;
	
	dir_path = gnome_cmd_dir_get_path (data->dir);

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->term_check)))
		command = g_strdup_printf (gnome_cmd_data_get_term(), in_command);
	else
		command = g_strdup (in_command);
	
	run_shell_command_indir (dir_path, command);
	
	g_free (command);
	gnome_cmd_dir_unref (data->dir);
	g_free (data);
}


static void
on_cancel (GtkWidget *button, RunDialogData *data)
{
	gnome_cmd_dir_unref (data->dir);
	g_free (data);
}


GtkWidget*
gnome_cmd_run_dialog_new (GnomeCmdDir *dir)
{
	GtkWidget *term_check;
	GnomeCmdStringDialog *dialog;
	RunDialogData *data = g_new (RunDialogData, 1);

	gnome_cmd_dir_ref (dir);
	
	dialog = (GnomeCmdStringDialog*)gnome_cmd_string_dialog_new_with_cancel (
		FALSE,
		_("Run program"),
		_("Enter command line to run"),
		PIXMAP_EXEC,
		(GnomeStringCallback)on_ok, (GtkSignalFunc)on_cancel,
		data);

	term_check = gtk_check_button_new_with_label (_("Execute in terminal"));
	gtk_widget_ref (term_check);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "term_check", term_check,
							  (GtkDestroyNotify)gtk_widget_unref);
	gtk_widget_show (term_check);
	gtk_box_pack_start (GTK_BOX (dialog->parent.vbox),
						term_check, TRUE, TRUE, 2);

	data->dir = dir;
	data->term_check = term_check;
	
	return GTK_WIDGET (dialog);
}



