/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_STRING_DIALOG_H__
#define __GNOME_CMD_STRING_DIALOG_H__


BEGIN_GNOME_DECLS

#define GNOME_CMD_STRING_DIALOG(obj) \
	GTK_CHECK_CAST (obj, gnome_cmd_string_dialog_get_type (), GnomeCmdStringDialog)
#define GNOME_CMD_STRING_DIALOG_CLASS(klass) \
	GTK_CHECK_CLASS_CAST (klass, gnome_cmd_string_dialog_get_type (), GnomeCmdStringDialogClass)
#define GNOME_CMD_IS_STRING_DIALOG(obj) \
	GTK_CHECK_TYPE (obj, gnome_cmd_string_dialog_get_type ())


typedef struct _GnomeCmdStringDialog GnomeCmdStringDialog;
typedef struct _GnomeCmdStringDialogPrivate GnomeCmdStringDialogPrivate;
typedef struct _GnomeCmdStringDialogClass GnomeCmdStringDialogClass;



struct _GnomeCmdStringDialog
{
	GnomeDialog parent;
	GnomeCmdStringDialogPrivate *priv;
};


struct _GnomeCmdStringDialogClass
{
	GnomeDialogClass parent_class;
};



GtkWidget* 
gnome_cmd_string_dialog_new_with_cancel (gboolean hidden,
										 const gchar *title,
										 const gchar *prompt,
										 Pixmap pixmap_id,
										 GnomeStringCallback ok_cb,
										 GtkSignalFunc cancel_cb,
										 gpointer user_data);

GtkWidget* 
gnome_cmd_string_dialog_new (gboolean hidden,
							 const gchar *title,
							 const gchar *prompt,
							 Pixmap pixmap_id,
							 GnomeStringCallback ok_cb,
							 gpointer userdata);

GtkType
gnome_cmd_string_dialog_get_type (void);


void
gnome_cmd_string_dialog_set_hidden (GnomeCmdStringDialog *dialog, gboolean hidden);

void
gnome_cmd_string_dialog_set_pixmap (GnomeCmdStringDialog *dialog, Pixmap pixmap_id);

void
gnome_cmd_string_dialog_set_title (GnomeCmdStringDialog *dialog, const gchar *title);

void
gnome_cmd_string_dialog_set_prompt (GnomeCmdStringDialog *dialog, const gchar *prompt);

void
gnome_cmd_string_dialog_set_userdata (GnomeCmdStringDialog *dialog, gpointer userdata);

void
gnome_cmd_string_dialog_set_ok_cb (GnomeCmdStringDialog *dialog, GnomeStringCallback ok_cb);

void
gnome_cmd_string_dialog_set_cancel_cb (GnomeCmdStringDialog *dialog, GtkSignalFunc cancel_cb);


#endif //__GNOME_CMD_STRING_DIALOG_H__


