/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include "gnome-cmd-includes.h"

GtkStyle *main_style, *list_style;


static GtkStyle *
create_style ()
{	
	GtkStyle *style;
	GdkFont *font = NULL;
	const gchar *font_name = gnome_cmd_data_get_font ();

	if (strcmp (font_name, "default") != 0)
	{
		font = gdk_font_load (font_name);		
	}

	style = gtk_style_new ();

	gdk_font_unref (style->font);
	gdk_font_ref (font);

	if (font)
		style->font = font;

	return style;
}


static void
adjust_main (void)
{
}


static void
adjust_list (void)
{
	GnomeCmdLayoutColors *cols = gnome_cmd_data_get_layout_colors ();

	list_style->fg[GTK_STATE_SELECTED] = *cols->curs_fg;
	list_style->fg[GTK_STATE_NORMAL] = *cols->norm_fg;

	list_style->bg[GTK_STATE_SELECTED] = *cols->curs_bg;
	list_style->base[GTK_STATE_NORMAL] = *cols->norm_bg;
	list_style->base[GTK_STATE_ACTIVE] = *cols->norm_bg;
}


void gnome_cmd_style_create (void)
{
	main_style = create_style ();
	list_style = create_style ();

	adjust_main ();
	adjust_list ();
}
