/* -*- c-file-style: "ruby" -*- */
/************************************************

  rbgdkevent.c -

  $Author: igarashi $
  $Date: 2000/09/02 10:05:42 $

  Copyright (C) 1998-2000 Yukihiro Matsumoto,
                          Daisuke Kanda,
                          Hiroshi Igarashi
************************************************/

#include "global.h"

/* VALUE gdkEventType; */
VALUE gdkEventAny;
VALUE gdkEventExpose;
VALUE gdkEventNoExpose;
VALUE gdkEventVisibility;
VALUE gdkEventMotion;
VALUE gdkEventButton;
VALUE gdkEventKey;
VALUE gdkEventCrossing;
VALUE gdkEventFocus;
VALUE gdkEventConfigure;
VALUE gdkEventProperty;
VALUE gdkEventSelection;
VALUE gdkEventProximity;
/*
VALUE gdkEventDragBegin;
VALUE gdkEventDragRequest;
VALUE gdkEventDropEnter;
VALUE gdkEventDropLeave;
VALUE gdkEventDropDataAvailable;
*/
VALUE gdkEventClient;
VALUE gdkEventOther;

/* GdkEvent */
static VALUE
gdkevent_type(self)
{
    return INT2NUM(get_gdkevent(self)->type);
}

/* GdkEventAny */
static VALUE
gdkeventany_window(self)
{
    return make_gdkwindow(get_gdkevent(self)->any.window);
}

/* GdkEventExpose */
static VALUE
gdkeventexpose_area(self)
    VALUE self;
{
    return make_gdkrectangle(&get_gdkevent(self)->expose.area);
}

static VALUE
gdkeventexpose_count(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->expose.count);
}

/* GdkEventVisibility */
static VALUE
gdkeventvisibility_state(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->visibility.state);
}

/* GdkEventMotion */
static VALUE
gdkeventmotion_time(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->motion.time);
}

static VALUE
gdkeventmotion_x(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->motion.x);
}

static VALUE
gdkeventmotion_y(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->motion.y);
}

static VALUE
gdkeventmotion_pressure(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->motion.pressure);
}

static VALUE
gdkeventmotion_xtilt(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->motion.xtilt);
}

static VALUE
gdkeventmotion_ytilt(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->motion.ytilt);
}

static VALUE
gdkeventmotion_source(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->motion.source);
}

static VALUE
gdkeventmotion_deviceid(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->motion.deviceid);
}

static VALUE
gdkeventmotion_x_root(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->motion.x_root);
}

static VALUE
gdkeventmotion_y_root(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->motion.y_root);
}

static VALUE
gdkeventmotion_state(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->motion.state);
}

static VALUE
gdkeventmotion_is_hint(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->motion.is_hint);
}

/* GdkEventButton */
static VALUE
gdkeventbutton_time(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->button.time);
}

static VALUE
gdkeventbutton_x(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->button.x);
}

static VALUE
gdkeventbutton_y(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->button.y);
}

static VALUE
gdkeventbutton_pressure(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->button.pressure);
}

static VALUE
gdkeventbutton_xtilt(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->button.xtilt);
}

static VALUE
gdkeventbutton_ytilt(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->button.ytilt);
}

static VALUE
gdkeventbutton_state(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->button.state);
}

static VALUE
gdkeventbutton_button(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->button.button);
}

static VALUE
gdkeventbutton_source(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->button.source);
}

static VALUE
gdkeventbutton_deviceid(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->button.deviceid);
}

static VALUE
gdkeventbutton_x_root(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->button.x_root);
}

static VALUE
gdkeventbutton_y_root(self)
    VALUE self;
{
    return rb_float_new(get_gdkevent(self)->button.y_root);
}

/* GdkEventKey */
static VALUE
gdkeventkey_time(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->key.time);
}

static VALUE
gdkeventkey_state(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->key.state);
}

static VALUE
gdkeventkey_keyval(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->key.keyval);
}

static VALUE
gdkeventkey_length(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->key.length);
}

static VALUE
gdkeventkey_string(self)
    VALUE self;
{
    return rb_str_new2(get_gdkevent(self)->key.string);
}

/* GdkEventCrossing */
static VALUE
gdkeventcrossing_subwindow(self)
    VALUE self;
{
    return make_gdkwindow(get_gdkevent(self)->crossing.subwindow);
}

static VALUE
gdkeventcrossing_detail(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->crossing.detail);
}

/* GdkEventFocus */
static VALUE
gdkeventfocus_in(self)
    VALUE self;
{
    /* it may return a bool... */
    return INT2NUM(get_gdkevent(self)->focus_change.in);
}

/* GdkEventConfigure */
static VALUE
gdkeventconfigure_x(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->configure.x);
}

static VALUE
gdkeventconfigure_y(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->configure.y);
}

static VALUE
gdkeventconfigure_width(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->configure.width);
}

static VALUE
gdkeventconfigure_height(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->configure.height);
}

/* GdkEventProperty */
static VALUE
gdkeventproperty_atom(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->property.atom);
}

static VALUE
gdkeventproperty_time(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->property.time);
}

static VALUE
gdkeventproperty_state(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->property.state);
}

/* GdkEventSelection */
static VALUE
gdkeventselection_selection(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->selection.selection);
}

static VALUE
gdkeventselection_target(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->selection.target);
}
static VALUE
gdkeventselection_property(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->selection.property);
}
static VALUE
gdkeventselection_requestor(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->selection.requestor);
}
static VALUE
gdkeventselection_time(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->selection.time);
}

/* GdkEventProximity */
static VALUE
gdkeventproximity_time(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->proximity.time);
}

static VALUE
gdkeventproximity_source(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->proximity.source);
}

static VALUE
gdkeventproximity_deviceid(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->proximity.deviceid);
}

/* GdkEventDragRequest */
#if 0 /* remove 1.2.x */
static VALUE
gdkeventdragrequest_requestor(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dragrequest.requestor);
}

static VALUE
gdkeventdragrequest_protocol_version(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dragrequest.u.flags.protocol_version);
}

static VALUE
gdkeventdragrequest_sendreply(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dragrequest.u.flags.sendreply)? Qtrue: Qfalse;
}

static VALUE
gdkeventdragrequest_willaccept(self)
    VALUE self;
{
    return (get_gdkevent(self)->dragrequest.u.flags.willaccept)? Qtrue: Qfalse;
}

static VALUE
gdkeventdragrequest_delete_data(self)
    VALUE self;
{
    return (get_gdkevent(self)->dragrequest.u.flags.delete_data)? Qtrue: Qfalse;
}

static VALUE
gdkeventdragrequest_senddata(self)
    VALUE self;
{
    return (get_gdkevent(self)->dragrequest.u.flags.senddata)? Qtrue: Qfalse;
}

static VALUE
gdkeventdragrequest_allflags(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dragrequest.u.allflags);
}

static VALUE
gdkeventdragrequest_isdrop(self)
    VALUE self;
{
    return (get_gdkevent(self)->dragrequest.isdrop)? Qtrue: Qfalse;
}

static VALUE
gdkeventdragrequest_drop_coords(self)
    VALUE self;
{
    return make_gdkpoint(&get_gdkevent(self)->dragrequest.drop_coords);
}

static VALUE
gdkeventdragrequest_data_type(self)
    VALUE self;
{
    return rb_str_new2(get_gdkevent(self)->dragrequest.data_type);
}

static VALUE
gdkeventdragrequest_timestamp(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dragrequest.timestamp);
}

/* GdkEventDragBegin */
static VALUE
gdkeventdragbegin_protocol_version(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dragbegin.u.flags.protocol_version);
}

static VALUE
gdkeventdragbegin_allflags(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dragbegin.u.allflags);
}

/* GdkEventDropEnter */
static VALUE
gdkeventdropenter_requestor(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropenter.requestor);
}

static VALUE
gdkeventdropenter_protocol_version(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropenter.u.flags.protocol_version);
}

static VALUE
gdkeventdropenter_sendreply(self)
    VALUE self;
{
    return (get_gdkevent(self)->dropenter.u.flags.sendreply)? Qtrue: Qfalse;
}

static VALUE
gdkeventdropenter_extended_typelist(self)
    VALUE self;
{
    return (get_gdkevent(self)->dropenter.u.flags.extended_typelist)? Qtrue: Qfalse;
}

static VALUE
gdkeventdropenter_allflags(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropenter.u.allflags);
}

/* GdkEventDropLeave */
static VALUE
gdkeventdropleave_requestor(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropleave.requestor);
}

static VALUE
gdkeventdropleave_protocol_version(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropleave.u.flags.protocol_version);
}

static VALUE
gdkeventdropleave_allflags(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropleave.u.allflags);
}

/* GdkEventDropDataAvailable */
static VALUE
gdkeventdropdataavailable_requestor(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropdataavailable.requestor);
}

static VALUE
gdkeventdropdataavailable_protocol_version(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropdataavailable.u.flags.protocol_version);
}

static VALUE
gdkeventdropdataavailable_isdrop(self)
    VALUE self;
{
    return (get_gdkevent(self)->dropdataavailable.u.flags.isdrop)? Qtrue: Qfalse;
}

static VALUE
gdkeventdropdataavailable_allflags(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropdataavailable.u.allflags);
}

static VALUE
gdkeventdropdataavailable_data_type(self)
    VALUE self;
{
    return rb_str_new2(get_gdkevent(self)->dropdataavailable.data_type);
}

static VALUE
gdkeventdropdataavailable_data_numbytes(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropdataavailable.data_numbytes);
}

static VALUE
gdkeventdropdataavailable_data(self)
    VALUE self;
{
    notimplemented();
}

static VALUE
gdkeventdropdataavailable_timestamp(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->dropdataavailable.timestamp);
}

static VALUE
gdkeventdropdataavailable_coords(self)
    VALUE self;
{
    return make_gdkpoint(&get_gdkevent(self)->dropdataavailable.coords);
}
#endif

/* GdkEventClient */
static VALUE
gdkeventclient_message_type(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->client.message_type);
}

static VALUE
gdkeventclient_data_format(self)
    VALUE self;
{
    return INT2NUM(get_gdkevent(self)->client.data_format);
}

static VALUE
gdkeventclient_data_byte(self)
    VALUE self;
{
    VALUE ary;
    int i;

    ary = rb_ary_new2(20);
    for (i=0; i<20; i++)
	rb_ary_push(ary, INT2FIX(get_gdkevent(self)->client.data.b[i]));

    return ary;
}

static VALUE
gdkeventclient_data_short(self)
    VALUE self;
{
    VALUE ary;
    int i;

    ary = rb_ary_new2(10);
    for (i=0; i<10; i++)
	rb_ary_push(ary, INT2FIX(get_gdkevent(self)->client.data.s[i]));

    return ary;
}

static VALUE
gdkeventclient_data_long(self)
    VALUE self;
{
    VALUE ary;
    int i;

    ary = rb_ary_new2(5);
    for (i=0; i<5; i++)
	rb_ary_push(ary, INT2FIX(get_gdkevent(self)->client.data.l[i]));

    return ary;
}

void
Init_gtk_gdk_event()
{
    gdkEvent = rb_define_class_under(mGdk, "Event", rb_cData);
    /* gdkEventType = rb_define_class_under(mGdk, "gdkEventType", gdkEvent); */
    gdkEventAny = rb_define_class_under(mGdk, "EventAny", gdkEvent);
    gdkEventExpose = rb_define_class_under(mGdk, "EventExpose", gdkEventAny);
    gdkEventNoExpose = rb_define_class_under(mGdk, "EventNoExpose", gdkEventAny);
    gdkEventVisibility = rb_define_class_under(mGdk, "EventVisibility", gdkEventAny);
    gdkEventMotion = rb_define_class_under(mGdk, "EventMotion", gdkEventAny);
    gdkEventButton = rb_define_class_under(mGdk, "EventButton", gdkEventAny);
    gdkEventKey = rb_define_class_under(mGdk, "EventKey", gdkEventAny);
    gdkEventCrossing = rb_define_class_under(mGdk, "EventCrossing", gdkEventAny);
    gdkEventFocus = rb_define_class_under(mGdk, "EventFocus", gdkEventAny);
    gdkEventConfigure = rb_define_class_under(mGdk, "EventConfigure", gdkEventAny);
    gdkEventProperty = rb_define_class_under(mGdk, "EventProperty", gdkEventAny);
    gdkEventSelection = rb_define_class_under(mGdk, "EventSelection", gdkEventAny);
    gdkEventProximity = rb_define_class_under(mGdk, "EventProximity", gdkEventAny);
    /*
      gdkEventDragBegin = rb_define_class_under(mGdk, "gdkEventDragBegin", gdkEventAny);
      gdkEventDragRequest = rb_define_class_under(mGdk, "gdkEventDragRequest", gdkEventAny);
      gdkEventDropEnter = rb_define_class_under(mGdk, "gdkEventDropEnter", gdkEventAny);
      gdkEventDropLeave = rb_define_class_under(mGdk, "gdkEventDropLeave", gdkEventAny);
      gdkEventDropDataAvailable = rb_define_class_under(mGdk, "gdkEventDropDataAvailable", gdkEventAny);
    */
    gdkEventClient = rb_define_class_under(mGdk, "EventClient", gdkEventAny);
    gdkEventOther = rb_define_class_under(mGdk, "EventOther", gdkEventAny);


    /* GdkEvent */
    rb_define_method(gdkEvent, "event_type", gdkevent_type, 0);

    /* GdkEventAny */
    rb_define_method(gdkEventAny, "window", gdkeventany_window, 0);

    /* GdkEventExpose */
    rb_define_method(gdkEventExpose, "area", gdkeventexpose_area, 0);
    rb_define_method(gdkEventExpose, "count", gdkeventexpose_count, 0);

    /* GdkEventVisibility */
    rb_define_method(gdkEventVisibility, "state", gdkeventvisibility_state, 0);

    /* GdkEventMotion */
    rb_define_method(gdkEventMotion, "time", gdkeventmotion_time, 0);
    rb_define_method(gdkEventMotion, "x", gdkeventmotion_x, 0);
    rb_define_method(gdkEventMotion, "y", gdkeventmotion_y, 0);
    rb_define_method(gdkEventMotion, "pressure", gdkeventmotion_pressure, 0);
    rb_define_method(gdkEventMotion, "xtilt", gdkeventmotion_xtilt, 0);
    rb_define_method(gdkEventMotion, "ytilt", gdkeventmotion_ytilt, 0);
    rb_define_method(gdkEventMotion, "state", gdkeventmotion_state, 0);
    rb_define_method(gdkEventMotion, "is_hint", gdkeventmotion_is_hint, 0);
    rb_define_method(gdkEventMotion, "source", gdkeventmotion_source, 0);
    rb_define_method(gdkEventMotion, "deviceid", gdkeventmotion_deviceid, 0);
    rb_define_method(gdkEventMotion, "x_root", gdkeventmotion_x_root, 0);
    rb_define_method(gdkEventMotion, "y_root", gdkeventmotion_y_root, 0);

    /* GdkEventButton */
    rb_define_method(gdkEventButton, "time", gdkeventbutton_time, 0);
    rb_define_method(gdkEventButton, "x", gdkeventbutton_x, 0);
    rb_define_method(gdkEventButton, "y", gdkeventbutton_y, 0);
    rb_define_method(gdkEventButton, "pressure", gdkeventbutton_pressure, 0);
    rb_define_method(gdkEventButton, "xtilt", gdkeventbutton_xtilt, 0);
    rb_define_method(gdkEventButton, "ytilt", gdkeventbutton_ytilt, 0);
    rb_define_method(gdkEventButton, "state", gdkeventbutton_state, 0);
    rb_define_method(gdkEventButton, "button", gdkeventbutton_button, 0);
    rb_define_method(gdkEventButton, "source", gdkeventbutton_source, 0);
    rb_define_method(gdkEventButton, "deviceid", gdkeventbutton_deviceid, 0);
    rb_define_method(gdkEventButton, "x_root", gdkeventbutton_x_root, 0);
    rb_define_method(gdkEventButton, "y_root", gdkeventbutton_y_root, 0);

    /* GdkEventKey */
    rb_define_method(gdkEventKey, "time",   gdkeventkey_time, 0);
    rb_define_method(gdkEventKey, "state",  gdkeventkey_state, 0);
    rb_define_method(gdkEventKey, "keyval", gdkeventkey_keyval, 0);
    rb_define_method(gdkEventKey, "length", gdkeventkey_length, 0);
    rb_define_method(gdkEventKey, "string", gdkeventkey_string, 0);

    /* GdkEventCrossing */
    rb_define_method(gdkEventCrossing, "subwindow", gdkeventcrossing_subwindow, 0);
    rb_define_method(gdkEventCrossing, "detail", gdkeventcrossing_detail, 0);

    /* GdkEventFocus */
    rb_define_method(gdkEventCrossing, "in", gdkeventfocus_in, 0);

    /* GdkEventConfigure */
    rb_define_method(gdkEventConfigure, "x", gdkeventconfigure_x, 0);
    rb_define_method(gdkEventConfigure, "y", gdkeventconfigure_y, 0);
    rb_define_method(gdkEventConfigure, "width", gdkeventconfigure_width, 0);
    rb_define_method(gdkEventConfigure, "height", gdkeventconfigure_height, 0);

    /* GdkEventProperty */
    rb_define_method(gdkEventProperty, "atom", gdkeventproperty_atom, 0);
    rb_define_method(gdkEventProperty, "time", gdkeventproperty_time, 0);
    rb_define_method(gdkEventProperty, "state", gdkeventproperty_state, 0);

    /* GdkEventSelection */
    rb_define_method(gdkEventSelection, "selection", gdkeventselection_selection, 0);
    rb_define_method(gdkEventSelection, "target", gdkeventselection_target, 0);
    rb_define_method(gdkEventSelection, "property", gdkeventselection_property, 0);
    rb_define_method(gdkEventSelection, "requestor", gdkeventselection_requestor, 0);
    rb_define_method(gdkEventSelection, "time", gdkeventselection_time, 0);

    /* GdkEventProximity */
    rb_define_method(gdkEventProximity, "time", gdkeventproximity_time, 0);
    rb_define_method(gdkEventProximity, "source", gdkeventproximity_source, 0);
    rb_define_method(gdkEventProximity, "deviceid", gdkeventproximity_deviceid, 0);

#if 0 /* remove 1.2.x */
    /* GdkEventDragRequest */
    rb_define_method(gdkEventDragRequest, "requestor", gdkeventdragrequest_requestor, 0);
    rb_define_method(gdkEventDragRequest, "protocol_version", gdkeventdragrequest_protocol_version, 0);
    rb_define_method(gdkEventDragRequest, "sendreply?", gdkeventdragrequest_sendreply, 0);
    rb_define_method(gdkEventDragRequest, "willaccept?", gdkeventdragrequest_willaccept, 0);
    rb_define_method(gdkEventDragRequest, "delete_data?", gdkeventdragrequest_delete_data, 0);
    rb_define_method(gdkEventDragRequest, "senddata?", gdkeventdragrequest_senddata, 0);
    rb_define_method(gdkEventDragRequest, "allflags", gdkeventdragrequest_allflags, 0);
    rb_define_method(gdkEventDragRequest, "isdrop?", gdkeventdragrequest_isdrop, 0);
    rb_define_method(gdkEventDragRequest, "drop_coords", gdkeventdragrequest_drop_coords, 0);
    rb_define_method(gdkEventDragRequest, "data_type", gdkeventdragrequest_data_type, 0);
    rb_define_method(gdkEventDragRequest, "timestamp", gdkeventdragrequest_timestamp, 0);

    /* GdkEventDragBegin */
    rb_define_method(gdkEventDragBegin, "protocol_version", gdkeventdragrequest_protocol_version, 0);
    rb_define_method(gdkEventDragBegin, "allflags", gdkeventdragrequest_allflags, 0);

    /* GdkEventDropEnter */
    rb_define_method(gdkEventDropEnter, "requestor", gdkeventdropenter_requestor, 0);
    rb_define_method(gdkEventDropEnter, "protocol_version", gdkeventdropenter_protocol_version, 0);
    rb_define_method(gdkEventDropEnter, "sendreply?", gdkeventdropenter_sendreply, 0);
    rb_define_method(gdkEventDropEnter, "extended_typelist?", gdkeventdropenter_extended_typelist, 0);
    rb_define_method(gdkEventDropEnter, "allflags", gdkeventdropenter_allflags, 0);

    /* GdkEventDropLeave */
    rb_define_method(gdkEventDropLeave, "requestor", gdkeventdropleave_requestor, 0);
    rb_define_method(gdkEventDropLeave, "protocol_version", gdkeventdropleave_protocol_version, 0);
    rb_define_method(gdkEventDropLeave, "allflags", gdkeventdropleave_allflags, 0);

    /* GdkEventDropDataAvailable */
    rb_define_method(gdkEventDropDataAvailable, "requestor", gdkeventdropdataavailable_requestor, 0);
    rb_define_method(gdkEventDropDataAvailable, "protocol_version", gdkeventdropdataavailable_protocol_version, 0);
    rb_define_method(gdkEventDropDataAvailable, "isdrop?", gdkeventdropdataavailable_isdrop, 0);
    rb_define_method(gdkEventDropDataAvailable, "allflags", gdkeventdropdataavailable_allflags, 0);
    rb_define_method(gdkEventDropDataAvailable, "data_type", gdkeventdropdataavailable_data_type, 0);
    rb_define_method(gdkEventDropDataAvailable, "data_numbytes", gdkeventdropdataavailable_data_numbytes, 0);
    rb_define_method(gdkEventDropDataAvailable, "data", gdkeventdropdataavailable_data, 0);
    rb_define_method(gdkEventDropDataAvailable, "timestamp", gdkeventdropdataavailable_timestamp, 0);
    rb_define_method(gdkEventDropDataAvailable, "coords", gdkeventdropdataavailable_coords, 0);

    /* GdkEventClient */
    rb_define_method(gdkEventClient, "message_type", gdkeventclient_message_type, 0);
    rb_define_method(gdkEventClient, "data_format", gdkeventclient_data_format, 0);
    rb_define_method(gdkEventClient, "data_byte", gdkeventclient_data_byte, 0);
    rb_define_method(gdkEventClient, "data_short", gdkeventclient_data_short, 0);
    rb_define_method(gdkEventClient, "data_long", gdkeventclient_data_long, 0);
#endif
}
