/* GnoSamba 0.3.3
 * copyright 1998-9 Perry Piplani
 * redistributable under the terms of the GPL:
 * http://www.gnu.org/copyleft/gpl.html
 */


#include "params.h"
#include "gtksamba.h"
#include <unistd.h>

#define DEF_SMB_CONF  "/etc/smb.conf"
#define DEF_RESTART  "/etc/rc.d/init.d/smb restart"

static GtkWidget *pbox=NULL;
static GtkWidget *conf_entry=NULL;
static GtkWidget *restart_entry=NULL;

void check_prefs(){
  gchar *path, *value;
  
  path=(char *)g_malloc((strlen(PACKAGE)+24)*sizeof(char));

 

  sprintf(path,"/%s/smblocal/conf",PACKAGE);
  value=gnome_config_get_string(path);
  if(value)
    g_free(value);
  else 
    gnome_config_set_string(path,DEF_SMB_CONF);

  value=gnome_config_get_string(path);
  if(!value)
    g_print("config bug found\n");
  else
    g_free(value);
  
  sprintf(path,"/%s/smblocal/restart",PACKAGE);
  value=gnome_config_get_string(path);
  if(value)
    g_free(value);
  else {
    printf("setting defaut restart\n");
    gnome_config_set_string(path,DEF_RESTART);
  }

  g_free(path);

  return;
}

char *get_config_val(char *sect, char *name){
  char *path, *value;

  path=(char *)g_malloc((strlen(sect)+strlen(name)+strlen(PACKAGE)+4)
			* sizeof(char));
  sprintf(path,"/%s/%s/%s",PACKAGE,sect,name);
  value=gnome_config_get_string(path);
  if(!value){
    /* lame bug work around */
    if(!strcmp(name,"conf"))
      value=g_strdup(DEF_SMB_CONF);
    if(!strcmp(name,"restart"))
      value=g_strdup(DEF_RESTART);
  }
  g_free(path);
  return value;

}



void c_apply_prefs(GtkWidget *widget, gint page, gpointer  data){
  char *path, *value;
  GtkWidget *entry;

  path=(char *)g_malloc((strlen(PACKAGE)+24)*sizeof(char));


  value=gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(conf_entry),
                                       FALSE);
  sprintf(path,"/%s/smblocal/conf",PACKAGE); 
  gnome_config_set_string(path,value);

  entry=gnome_entry_gtk_entry(GNOME_ENTRY(restart_entry));
  value=gtk_entry_get_text(GTK_ENTRY(entry));
  sprintf(path,"/%s/smblocal/restart",PACKAGE); 
  gnome_config_set_string(path,value);
  
  g_free(path);

  return;
}


void c_make_pref_box(GtkWidget *widget, gpointer  data){
  GtkWidget *entry;
  GtkWidget *label;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *hbox;
  char *value;

  pbox=gnome_property_box_new();
  gtk_signal_connect(GTK_OBJECT(pbox),"apply",
			    GTK_SIGNAL_FUNC(c_apply_prefs),
			    NULL);
  
  vbox = gtk_vbox_new(TRUE,0);
  gtk_widget_show (vbox);

  frame = gtk_frame_new ("Samba Configuration File");
  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  hbox = gtk_hbox_new(FALSE,0);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_widget_show (hbox);

  conf_entry = gnome_file_entry_new("local_conf","Samba Configuration File");
  value=get_config_val("smblocal","conf");
  entry=gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(conf_entry));
  gtk_entry_set_text (GTK_ENTRY (entry),value);
  
  g_free(value);
  gtk_signal_connect_object(GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(pbox));
  
  gtk_box_pack_start (GTK_BOX (hbox),conf_entry , 
		      TRUE, TRUE, 10);
  gtk_widget_show (conf_entry);  


  frame = gtk_frame_new ("Samba Restart Command");
  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);
  
  hbox = gtk_hbox_new(FALSE,0);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_widget_show (hbox);

  
  restart_entry = gnome_entry_new("local_restart");
  value=get_config_val("smblocal","restart");
  entry=gnome_entry_gtk_entry(GNOME_ENTRY(restart_entry));
  gtk_entry_set_text (GTK_ENTRY (entry),value);
  g_free(value);
  gtk_signal_connect_object(GTK_OBJECT(entry),"changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(pbox));
  gtk_box_pack_start (GTK_BOX (hbox), restart_entry , 
		      TRUE, TRUE, 10);
  gtk_widget_show (restart_entry);
  
  label = gtk_label_new ("Local System");
  gtk_widget_show (label);
  gnome_property_box_append_page(GNOME_PROPERTY_BOX(pbox),vbox,label);

  frame = gtk_frame_new ("Remote Systems");
  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  gtk_widget_show (frame);
  
  label = gtk_label_new ("This Feature Coming Soon");
  gtk_container_add (GTK_CONTAINER (frame), label);
  gtk_widget_show (label);
  
  label = gtk_label_new ("Remote Systems");
  gtk_widget_show (label);
  gnome_property_box_append_page(GNOME_PROPERTY_BOX(pbox), frame, label);

  gtk_widget_show(pbox);
  return;
}


