indexing

	description:

		"Shared exception handling"

	pattern: "Singleton"
	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 1999, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 12:50:16 $"
	revision: "$Revision: 1.3 $"

class KL_SHARED_EXCEPTIONS

feature -- Access

	Exceptions: KL_EXCEPTIONS is
			-- Exception handling
		once
			create Result
		ensure
			exceptions_not_void: Result /= Void
		end

feature -- Obsolete

	exceptions_: KL_EXCEPTIONS is
			-- Exception handling
		obsolete
			"Use `Exceptions' instead."
		once
			Result := Exceptions
		ensure
			exceptions__not_void: Result /= Void
		end

end
