indexing

	description:

		"Underlying operating systems"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2001-2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 12:50:16 $"
	revision: "$Revision: 1.9 $"

class KL_OPERATING_SYSTEM

feature -- Status report

	is_windows: BOOLEAN is
			-- Is underlying operating system Windows-like?
		local
			cwd: STRING
		once
			if equal (variable_value ("GOBO_OS"), "windows") then
				Result := True
			elseif equal (variable_value ("OS"), "Windows_NT") then
				Result := True
			else
				cwd := current_working_directory
				if cwd.count >= 3 then
					if (cwd.item (2) = ':' and cwd.item (3) = '\') then
						Result := True
					elseif (cwd.item (1) = '\' and cwd.item (2) = '\') then
						Result := True
					end
				end
			end
		end

	is_unix: BOOLEAN is
			-- Is underlying operating system Unix-like?
		local
			cwd: STRING
		once
			if equal (variable_value ("GOBO_OS"), "unix") then
				Result := True
			else
				cwd := current_working_directory
				if cwd.count > 0 then
					Result := cwd.item (1) = '/'
				end
			end
		end

	is_dotnet: BOOLEAN is
			-- Has this application been compiled with Eiffel for .NET?







		once
			Result := False

		end

feature {NONE} -- Implementation

	current_working_directory: STRING is
			-- Name of current working directory;
			-- Return absolute pathname with the naming 
			-- convention of the underlying file system
			-- (Return a new object at each call.)
		do

			basic_directory.connect_to_current_working_directory
			Result := clone (basic_directory.last_entry)
			basic_directory.disconnect







		ensure
			current_working_directory_not_void: Result /= Void
		end

	variable_value (a_variable: STRING): STRING is
			-- Value of environment variable `a_variable',
			-- Void if `a_variable' has not been set
		require
			a_variable_not_void: a_variable /= Void















		do
			Result := environment_impl.get_environment_variable (a_variable)

		end


	basic_directory: BASIC_DIRECTORY
			-- Implementation

	environment_impl: SYSTEM is
			-- Execution environment implementation
		once
			create Result
		ensure
			environment_impl_not_void: Result /= Void
		end






















end
