indexing

	description:

		"Local system clocks (precision to the second)"

	library: "Gobo Eiffel Time Library"
	copyright: "Copyright (c) 2001, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:01:32 $"
	revision: "$Revision: 1.4 $"

class DT_SYSTEM_CLOCK

inherit

	DT_CLOCK

	DT_GREGORIAN_CALENDAR
		export {NONE} all end

	KL_SYSTEM_CLOCK
		export {NONE} all end

creation

	make

feature -- Setting

	set_time_to_now (a_time: DT_TIME) is
			-- Set `a_time' to current local time.
		do
			set_local_time
			if second >= Seconds_in_minute then
				second := Seconds_in_minute - 1
			end
			a_time.set_precise_hour_minute_second (hour, minute, second, 0)
		end

	set_date_to_now (a_date: DT_DATE) is
			-- Set `a_date' to current local date.
		do
			set_local_time
			a_date.set_year_month_day (year, month, day)
		end

	set_date_time_to_now (a_date_time: DT_DATE_TIME) is
			-- Set `a_date_time' to current local date time.
		do
			set_local_time
			if second >= Seconds_in_minute then
				second := Seconds_in_minute - 1
			end
			a_date_time.set_year_month_day (year, month, day)
			a_date_time.set_precise_hour_minute_second (hour, minute, second, 0)
		end

end
