indexing
	
	description:
	
		"External resolver that opens files on the local filesystem"
	
	library: "Gobo Eiffel XML Library"
	copyright: "Copyright (c) 2001, Andreas Leitner and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:11:25 $"
	revision: "$Revision: 1.3 $"
	
class XM_STRING_EXTERNAL_RESOLVER

inherit

	XM_EXTERNAL_RESOLVER
	
	KL_IMPORTED_STRING_ROUTINES
		export {NONE} all end
		
creation

	make
	
feature {NONE} -- Creation

	make is
			-- Make.
		do
			create strings.make_default
			last_error := "no stream"
		ensure
			empty: strings.is_empty
		end
		
feature -- Access

	strings: DS_HASH_TABLE [STRING, STRING]
			-- Table of strings indexed by resolution names.
			
feature -- Action(s)

	resolve (a_system_name: STRING) is
			-- Open file with corresponding name.
		do
			if strings.has (a_system_name) then
				last_error := Void
				create {KL_STRING_INPUT_STREAM} last_stream.make (strings.item (a_system_name))
			else
				last_error := STRING_.concat ("cannot find stream named: ", a_system_name)
				last_stream := Void
			end
		end
		
feature -- Result

	last_stream: KI_CHARACTER_INPUT_STREAM
			-- File matching stream.
			
	last_error: STRING
			-- Last error.
		
	has_error: BOOLEAN is
			-- Is there an error.
		do
			Result := last_error /= Void
		end

invariant

	error_or_stream: last_stream /= Void xor last_error /= Void
	strings_not_void: strings /= Void
		
end
