/* vim: set sw=8: -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * gog-logfit.h :  
 *
 * Copyright (C) 2005 Jean Brefort (jean.brefort@normalesup.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GOG_LOGFIT_H
#define GOG_LOGFIT_H

#include <goffice/graph/gog-reg-curve.h>
#include <goffice/utils/go-regression.h>

G_BEGIN_DECLS

typedef  GogRegCurve GogLogFitCurve;

typedef GogRegCurveClass GogLogFitCurveClass;

#define GOG_LOG_FIT_CURVE_TYPE	(gog_log_fit_curve_get_type ())
#define GOG_LOG_FIT_CURVE(o)	(G_TYPE_CHECK_INSTANCE_CAST ((o), GOG_LOG_FIT_CURVE_TYPE, GogLogFitCurve))
#define GOG_IS_LOG_FIT_CURVE(o)	(G_TYPE_CHECK_INSTANCE_TYPE ((o), GOG_LOG_FIT_CURVE_TYPE))

GType gog_log_fit_curve_get_type (void);

G_END_DECLS

#endif	/* GOG_LOGFIT_H */
