// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudwatchevidentlyiface provides an interface to enable mocking the Amazon CloudWatch Evidently service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudwatchevidentlyiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/cloudwatchevidently"
)

// CloudWatchEvidentlyAPI provides an interface to enable mocking the
// cloudwatchevidently.CloudWatchEvidently service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon CloudWatch Evidently.
//    func myFunc(svc cloudwatchevidentlyiface.CloudWatchEvidentlyAPI) bool {
//        // Make svc.BatchEvaluateFeature request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := cloudwatchevidently.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockCloudWatchEvidentlyClient struct {
//        cloudwatchevidentlyiface.CloudWatchEvidentlyAPI
//    }
//    func (m *mockCloudWatchEvidentlyClient) BatchEvaluateFeature(input *cloudwatchevidently.BatchEvaluateFeatureInput) (*cloudwatchevidently.BatchEvaluateFeatureOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockCloudWatchEvidentlyClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CloudWatchEvidentlyAPI interface {
	BatchEvaluateFeature(*cloudwatchevidently.BatchEvaluateFeatureInput) (*cloudwatchevidently.BatchEvaluateFeatureOutput, error)
	BatchEvaluateFeatureWithContext(aws.Context, *cloudwatchevidently.BatchEvaluateFeatureInput, ...request.Option) (*cloudwatchevidently.BatchEvaluateFeatureOutput, error)
	BatchEvaluateFeatureRequest(*cloudwatchevidently.BatchEvaluateFeatureInput) (*request.Request, *cloudwatchevidently.BatchEvaluateFeatureOutput)

	CreateExperiment(*cloudwatchevidently.CreateExperimentInput) (*cloudwatchevidently.CreateExperimentOutput, error)
	CreateExperimentWithContext(aws.Context, *cloudwatchevidently.CreateExperimentInput, ...request.Option) (*cloudwatchevidently.CreateExperimentOutput, error)
	CreateExperimentRequest(*cloudwatchevidently.CreateExperimentInput) (*request.Request, *cloudwatchevidently.CreateExperimentOutput)

	CreateFeature(*cloudwatchevidently.CreateFeatureInput) (*cloudwatchevidently.CreateFeatureOutput, error)
	CreateFeatureWithContext(aws.Context, *cloudwatchevidently.CreateFeatureInput, ...request.Option) (*cloudwatchevidently.CreateFeatureOutput, error)
	CreateFeatureRequest(*cloudwatchevidently.CreateFeatureInput) (*request.Request, *cloudwatchevidently.CreateFeatureOutput)

	CreateLaunch(*cloudwatchevidently.CreateLaunchInput) (*cloudwatchevidently.CreateLaunchOutput, error)
	CreateLaunchWithContext(aws.Context, *cloudwatchevidently.CreateLaunchInput, ...request.Option) (*cloudwatchevidently.CreateLaunchOutput, error)
	CreateLaunchRequest(*cloudwatchevidently.CreateLaunchInput) (*request.Request, *cloudwatchevidently.CreateLaunchOutput)

	CreateProject(*cloudwatchevidently.CreateProjectInput) (*cloudwatchevidently.CreateProjectOutput, error)
	CreateProjectWithContext(aws.Context, *cloudwatchevidently.CreateProjectInput, ...request.Option) (*cloudwatchevidently.CreateProjectOutput, error)
	CreateProjectRequest(*cloudwatchevidently.CreateProjectInput) (*request.Request, *cloudwatchevidently.CreateProjectOutput)

	DeleteExperiment(*cloudwatchevidently.DeleteExperimentInput) (*cloudwatchevidently.DeleteExperimentOutput, error)
	DeleteExperimentWithContext(aws.Context, *cloudwatchevidently.DeleteExperimentInput, ...request.Option) (*cloudwatchevidently.DeleteExperimentOutput, error)
	DeleteExperimentRequest(*cloudwatchevidently.DeleteExperimentInput) (*request.Request, *cloudwatchevidently.DeleteExperimentOutput)

	DeleteFeature(*cloudwatchevidently.DeleteFeatureInput) (*cloudwatchevidently.DeleteFeatureOutput, error)
	DeleteFeatureWithContext(aws.Context, *cloudwatchevidently.DeleteFeatureInput, ...request.Option) (*cloudwatchevidently.DeleteFeatureOutput, error)
	DeleteFeatureRequest(*cloudwatchevidently.DeleteFeatureInput) (*request.Request, *cloudwatchevidently.DeleteFeatureOutput)

	DeleteLaunch(*cloudwatchevidently.DeleteLaunchInput) (*cloudwatchevidently.DeleteLaunchOutput, error)
	DeleteLaunchWithContext(aws.Context, *cloudwatchevidently.DeleteLaunchInput, ...request.Option) (*cloudwatchevidently.DeleteLaunchOutput, error)
	DeleteLaunchRequest(*cloudwatchevidently.DeleteLaunchInput) (*request.Request, *cloudwatchevidently.DeleteLaunchOutput)

	DeleteProject(*cloudwatchevidently.DeleteProjectInput) (*cloudwatchevidently.DeleteProjectOutput, error)
	DeleteProjectWithContext(aws.Context, *cloudwatchevidently.DeleteProjectInput, ...request.Option) (*cloudwatchevidently.DeleteProjectOutput, error)
	DeleteProjectRequest(*cloudwatchevidently.DeleteProjectInput) (*request.Request, *cloudwatchevidently.DeleteProjectOutput)

	EvaluateFeature(*cloudwatchevidently.EvaluateFeatureInput) (*cloudwatchevidently.EvaluateFeatureOutput, error)
	EvaluateFeatureWithContext(aws.Context, *cloudwatchevidently.EvaluateFeatureInput, ...request.Option) (*cloudwatchevidently.EvaluateFeatureOutput, error)
	EvaluateFeatureRequest(*cloudwatchevidently.EvaluateFeatureInput) (*request.Request, *cloudwatchevidently.EvaluateFeatureOutput)

	GetExperiment(*cloudwatchevidently.GetExperimentInput) (*cloudwatchevidently.GetExperimentOutput, error)
	GetExperimentWithContext(aws.Context, *cloudwatchevidently.GetExperimentInput, ...request.Option) (*cloudwatchevidently.GetExperimentOutput, error)
	GetExperimentRequest(*cloudwatchevidently.GetExperimentInput) (*request.Request, *cloudwatchevidently.GetExperimentOutput)

	GetExperimentResults(*cloudwatchevidently.GetExperimentResultsInput) (*cloudwatchevidently.GetExperimentResultsOutput, error)
	GetExperimentResultsWithContext(aws.Context, *cloudwatchevidently.GetExperimentResultsInput, ...request.Option) (*cloudwatchevidently.GetExperimentResultsOutput, error)
	GetExperimentResultsRequest(*cloudwatchevidently.GetExperimentResultsInput) (*request.Request, *cloudwatchevidently.GetExperimentResultsOutput)

	GetFeature(*cloudwatchevidently.GetFeatureInput) (*cloudwatchevidently.GetFeatureOutput, error)
	GetFeatureWithContext(aws.Context, *cloudwatchevidently.GetFeatureInput, ...request.Option) (*cloudwatchevidently.GetFeatureOutput, error)
	GetFeatureRequest(*cloudwatchevidently.GetFeatureInput) (*request.Request, *cloudwatchevidently.GetFeatureOutput)

	GetLaunch(*cloudwatchevidently.GetLaunchInput) (*cloudwatchevidently.GetLaunchOutput, error)
	GetLaunchWithContext(aws.Context, *cloudwatchevidently.GetLaunchInput, ...request.Option) (*cloudwatchevidently.GetLaunchOutput, error)
	GetLaunchRequest(*cloudwatchevidently.GetLaunchInput) (*request.Request, *cloudwatchevidently.GetLaunchOutput)

	GetProject(*cloudwatchevidently.GetProjectInput) (*cloudwatchevidently.GetProjectOutput, error)
	GetProjectWithContext(aws.Context, *cloudwatchevidently.GetProjectInput, ...request.Option) (*cloudwatchevidently.GetProjectOutput, error)
	GetProjectRequest(*cloudwatchevidently.GetProjectInput) (*request.Request, *cloudwatchevidently.GetProjectOutput)

	ListExperiments(*cloudwatchevidently.ListExperimentsInput) (*cloudwatchevidently.ListExperimentsOutput, error)
	ListExperimentsWithContext(aws.Context, *cloudwatchevidently.ListExperimentsInput, ...request.Option) (*cloudwatchevidently.ListExperimentsOutput, error)
	ListExperimentsRequest(*cloudwatchevidently.ListExperimentsInput) (*request.Request, *cloudwatchevidently.ListExperimentsOutput)

	ListExperimentsPages(*cloudwatchevidently.ListExperimentsInput, func(*cloudwatchevidently.ListExperimentsOutput, bool) bool) error
	ListExperimentsPagesWithContext(aws.Context, *cloudwatchevidently.ListExperimentsInput, func(*cloudwatchevidently.ListExperimentsOutput, bool) bool, ...request.Option) error

	ListFeatures(*cloudwatchevidently.ListFeaturesInput) (*cloudwatchevidently.ListFeaturesOutput, error)
	ListFeaturesWithContext(aws.Context, *cloudwatchevidently.ListFeaturesInput, ...request.Option) (*cloudwatchevidently.ListFeaturesOutput, error)
	ListFeaturesRequest(*cloudwatchevidently.ListFeaturesInput) (*request.Request, *cloudwatchevidently.ListFeaturesOutput)

	ListFeaturesPages(*cloudwatchevidently.ListFeaturesInput, func(*cloudwatchevidently.ListFeaturesOutput, bool) bool) error
	ListFeaturesPagesWithContext(aws.Context, *cloudwatchevidently.ListFeaturesInput, func(*cloudwatchevidently.ListFeaturesOutput, bool) bool, ...request.Option) error

	ListLaunches(*cloudwatchevidently.ListLaunchesInput) (*cloudwatchevidently.ListLaunchesOutput, error)
	ListLaunchesWithContext(aws.Context, *cloudwatchevidently.ListLaunchesInput, ...request.Option) (*cloudwatchevidently.ListLaunchesOutput, error)
	ListLaunchesRequest(*cloudwatchevidently.ListLaunchesInput) (*request.Request, *cloudwatchevidently.ListLaunchesOutput)

	ListLaunchesPages(*cloudwatchevidently.ListLaunchesInput, func(*cloudwatchevidently.ListLaunchesOutput, bool) bool) error
	ListLaunchesPagesWithContext(aws.Context, *cloudwatchevidently.ListLaunchesInput, func(*cloudwatchevidently.ListLaunchesOutput, bool) bool, ...request.Option) error

	ListProjects(*cloudwatchevidently.ListProjectsInput) (*cloudwatchevidently.ListProjectsOutput, error)
	ListProjectsWithContext(aws.Context, *cloudwatchevidently.ListProjectsInput, ...request.Option) (*cloudwatchevidently.ListProjectsOutput, error)
	ListProjectsRequest(*cloudwatchevidently.ListProjectsInput) (*request.Request, *cloudwatchevidently.ListProjectsOutput)

	ListProjectsPages(*cloudwatchevidently.ListProjectsInput, func(*cloudwatchevidently.ListProjectsOutput, bool) bool) error
	ListProjectsPagesWithContext(aws.Context, *cloudwatchevidently.ListProjectsInput, func(*cloudwatchevidently.ListProjectsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*cloudwatchevidently.ListTagsForResourceInput) (*cloudwatchevidently.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *cloudwatchevidently.ListTagsForResourceInput, ...request.Option) (*cloudwatchevidently.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*cloudwatchevidently.ListTagsForResourceInput) (*request.Request, *cloudwatchevidently.ListTagsForResourceOutput)

	PutProjectEvents(*cloudwatchevidently.PutProjectEventsInput) (*cloudwatchevidently.PutProjectEventsOutput, error)
	PutProjectEventsWithContext(aws.Context, *cloudwatchevidently.PutProjectEventsInput, ...request.Option) (*cloudwatchevidently.PutProjectEventsOutput, error)
	PutProjectEventsRequest(*cloudwatchevidently.PutProjectEventsInput) (*request.Request, *cloudwatchevidently.PutProjectEventsOutput)

	StartExperiment(*cloudwatchevidently.StartExperimentInput) (*cloudwatchevidently.StartExperimentOutput, error)
	StartExperimentWithContext(aws.Context, *cloudwatchevidently.StartExperimentInput, ...request.Option) (*cloudwatchevidently.StartExperimentOutput, error)
	StartExperimentRequest(*cloudwatchevidently.StartExperimentInput) (*request.Request, *cloudwatchevidently.StartExperimentOutput)

	StartLaunch(*cloudwatchevidently.StartLaunchInput) (*cloudwatchevidently.StartLaunchOutput, error)
	StartLaunchWithContext(aws.Context, *cloudwatchevidently.StartLaunchInput, ...request.Option) (*cloudwatchevidently.StartLaunchOutput, error)
	StartLaunchRequest(*cloudwatchevidently.StartLaunchInput) (*request.Request, *cloudwatchevidently.StartLaunchOutput)

	StopExperiment(*cloudwatchevidently.StopExperimentInput) (*cloudwatchevidently.StopExperimentOutput, error)
	StopExperimentWithContext(aws.Context, *cloudwatchevidently.StopExperimentInput, ...request.Option) (*cloudwatchevidently.StopExperimentOutput, error)
	StopExperimentRequest(*cloudwatchevidently.StopExperimentInput) (*request.Request, *cloudwatchevidently.StopExperimentOutput)

	StopLaunch(*cloudwatchevidently.StopLaunchInput) (*cloudwatchevidently.StopLaunchOutput, error)
	StopLaunchWithContext(aws.Context, *cloudwatchevidently.StopLaunchInput, ...request.Option) (*cloudwatchevidently.StopLaunchOutput, error)
	StopLaunchRequest(*cloudwatchevidently.StopLaunchInput) (*request.Request, *cloudwatchevidently.StopLaunchOutput)

	TagResource(*cloudwatchevidently.TagResourceInput) (*cloudwatchevidently.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *cloudwatchevidently.TagResourceInput, ...request.Option) (*cloudwatchevidently.TagResourceOutput, error)
	TagResourceRequest(*cloudwatchevidently.TagResourceInput) (*request.Request, *cloudwatchevidently.TagResourceOutput)

	UntagResource(*cloudwatchevidently.UntagResourceInput) (*cloudwatchevidently.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *cloudwatchevidently.UntagResourceInput, ...request.Option) (*cloudwatchevidently.UntagResourceOutput, error)
	UntagResourceRequest(*cloudwatchevidently.UntagResourceInput) (*request.Request, *cloudwatchevidently.UntagResourceOutput)

	UpdateExperiment(*cloudwatchevidently.UpdateExperimentInput) (*cloudwatchevidently.UpdateExperimentOutput, error)
	UpdateExperimentWithContext(aws.Context, *cloudwatchevidently.UpdateExperimentInput, ...request.Option) (*cloudwatchevidently.UpdateExperimentOutput, error)
	UpdateExperimentRequest(*cloudwatchevidently.UpdateExperimentInput) (*request.Request, *cloudwatchevidently.UpdateExperimentOutput)

	UpdateFeature(*cloudwatchevidently.UpdateFeatureInput) (*cloudwatchevidently.UpdateFeatureOutput, error)
	UpdateFeatureWithContext(aws.Context, *cloudwatchevidently.UpdateFeatureInput, ...request.Option) (*cloudwatchevidently.UpdateFeatureOutput, error)
	UpdateFeatureRequest(*cloudwatchevidently.UpdateFeatureInput) (*request.Request, *cloudwatchevidently.UpdateFeatureOutput)

	UpdateLaunch(*cloudwatchevidently.UpdateLaunchInput) (*cloudwatchevidently.UpdateLaunchOutput, error)
	UpdateLaunchWithContext(aws.Context, *cloudwatchevidently.UpdateLaunchInput, ...request.Option) (*cloudwatchevidently.UpdateLaunchOutput, error)
	UpdateLaunchRequest(*cloudwatchevidently.UpdateLaunchInput) (*request.Request, *cloudwatchevidently.UpdateLaunchOutput)

	UpdateProject(*cloudwatchevidently.UpdateProjectInput) (*cloudwatchevidently.UpdateProjectOutput, error)
	UpdateProjectWithContext(aws.Context, *cloudwatchevidently.UpdateProjectInput, ...request.Option) (*cloudwatchevidently.UpdateProjectOutput, error)
	UpdateProjectRequest(*cloudwatchevidently.UpdateProjectInput) (*request.Request, *cloudwatchevidently.UpdateProjectOutput)

	UpdateProjectDataDelivery(*cloudwatchevidently.UpdateProjectDataDeliveryInput) (*cloudwatchevidently.UpdateProjectDataDeliveryOutput, error)
	UpdateProjectDataDeliveryWithContext(aws.Context, *cloudwatchevidently.UpdateProjectDataDeliveryInput, ...request.Option) (*cloudwatchevidently.UpdateProjectDataDeliveryOutput, error)
	UpdateProjectDataDeliveryRequest(*cloudwatchevidently.UpdateProjectDataDeliveryInput) (*request.Request, *cloudwatchevidently.UpdateProjectDataDeliveryOutput)
}

var _ CloudWatchEvidentlyAPI = (*cloudwatchevidently.CloudWatchEvidently)(nil)
