# gozerbot/threadloop.py
#
#

""" class to implement start/stoppable threads """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog
from gozerbot.thr import start_new_thread
import Queue

class ThreadLoop(object):

    def __init__(self, name):
        self.name = name
        self.stopped = False
        self.running = False
        self.outs = []
        self.queue = Queue.Queue()

    def _loop(self):
        rlog(5, self.name, 'starting loop')
        self.running = True
        while not self.stopped:
            data = self.queue.get()
            if self.stopped:
                return
            self.handle(*data)
        rlog(5, self.name, 'stopping loop')

    def put(self, *data):
        self.queue.put_nowait(data)

    def start(self):
        if not self.running:
            start_new_thread(self._loop, ())

    def stop(self):
        self.stopped = True
        self.queue.put(None)

    def handle(self):
        """ overload this """
        pass
