# tests/test_hg.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'hg')

class test_hg(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def test_hg_annotate(self):
        result = self.b.test('hg-annotate')
        self.assert_(stringinlist('<file>', result))

    def test_hg_annotate2(self):
        result = self.b.test('hg-annotate gozerplugs/plugs/hg.py')
        self.assert_(stringinlist('changed by', result))

    def test_hg_annotate4(self):
        result = self.b.test('hg-annotate mekker gozerplugs/plugs/hg.py')
        self.assert_(stringinlist('valid number', result))

    def test_hg_annotate5(self):
        result = self.b.test('hg-annotate mekker')
        self.assert_(stringinlist('file not found', result))

    def test_hg_annotate5(self):
        result = self.b.test('hg-annotate /etc/passwd')
        self.assert_(stringinlist('permission denied', result))

    def test_hg_annotate6(self):
        result = self.b.test('hg-annotate 100000 gozerplugs/plugs/hg.py')
        self.assert_(stringinlist('returned code', result))

    def test_hg_annotate7(self):
        result = self.b.test('hg-annotate 1494 gozerplugs/plugs/hg.py')
        self.assert_(stringinlist('changed by', result))

    def test_hg_changes(self):
        result = self.b.test('hg-changes')
        self.assert_(stringinlist('<rel>', result))

    def test_hg_changes2(self):
        result = self.b.test('hg-changes 1000')
        self.assert_(stringinlist('1000', result))

    def test_hg_changes3(self):
        result = self.b.test('hg-changes mekker')
        self.assert_(stringinlist('valid number', result))

    def test_hg_changes4(self):
        result = self.b.test('hg-changes 1000 mekker')
        self.assert_(stringinlist('valid number', result))

    def test_hg_changes5(self):
        result = self.b.test('hg-changes 1000 1001')
        self.assert_(stringinlist('1000 - 1001', result))

    def test_hg_changes6(self):
        result = self.b.test('hg-changes 100000 1001')
        self.assert_(stringinlist('returned code', result))

    def test_hg_committers(self):
        result = self.b.test('hg-committers')
        self.assert_(stringinlist('bart@localhost', result))

    def test_hg_committers(self):
        result = self.b.test('hg-committers short')
        self.assert_(stringinlist('bart', result))

    def test_hg_log(self):
        result = self.b.test('hg-log /etc/passwd')
        self.assert_(stringinlist('denied', result))

    def test_hg_log(self):
        result = self.b.test('hg-log')
        self.assert_(stringinlist('log result', result))

    def test_hg_log(self):
        result = self.b.test('hg-log gozerplugs/plugs/hg.py')
        self.assert_(stringinlist('log result', result))
