# gozerbot/utils/locking.py
#
#

""" generic functions """

__copyright__ = 'this file is in the public domain'

from log import rlog
from trace import whichmodule
import logging, sys

locks = []

def lockdec(lock):

    """ locking decorator. """

    def locked(func):

        """ locking function for %s """ % str(func)

        def lockedfunc(*args, **kwargs):
            """ the locked function. """

            where = whichmodule(1)
            rlog(1, 'locking', 'locking on %s' % where)
            lock.acquire()
            locks.append(str(func))
            res = None

            try:
                res = func(*args, **kwargs)
            finally:
                lock.release()
                locks.remove(str(func))

            return res

        return lockedfunc

    return locked
