/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvaspolylineview.h - view for polyline item.
 */
#ifndef __GOO_CANVAS_POLYLINE_VIEW_H__
#define __GOO_CANVAS_POLYLINE_VIEW_H__

#include <gtk/gtk.h>
#include "goocanvasitemviewsimple.h"
#include "goocanvaspolyline.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_POLYLINE_VIEW            (goo_canvas_polyline_view_get_type ())
#define GOO_CANVAS_POLYLINE_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_POLYLINE_VIEW, GooCanvasPolylineView))
#define GOO_CANVAS_POLYLINE_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_POLYLINE_VIEW, GooCanvasPolylineViewClass))
#define GOO_IS_CANVAS_POLYLINE_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_POLYLINE_VIEW))
#define GOO_IS_CANVAS_POLYLINE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_POLYLINE_VIEW))
#define GOO_CANVAS_POLYLINE_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_POLYLINE_VIEW, GooCanvasPolylineViewClass))


typedef struct _GooCanvasPolylineView       GooCanvasPolylineView;
typedef struct _GooCanvasPolylineViewClass  GooCanvasPolylineViewClass;

/**
 * GooCanvasPolylineView
 *
 * The #GooCanvasPolylineView-struct struct contains private data only.
 */
struct _GooCanvasPolylineView
{
  GooCanvasItemViewSimple parent_object;
};

struct _GooCanvasPolylineViewClass
{
  GooCanvasItemViewSimpleClass parent_class;
};


GType              goo_canvas_polyline_view_get_type (void) G_GNUC_CONST;
GooCanvasItemView* goo_canvas_polyline_view_new      (GooCanvasView     *canvas_view,
						      GooCanvasItemView *parent_view,
						      GooCanvasPolyline *polyline);


G_END_DECLS

#endif /* __GOO_CANVAS_POLYLINE_VIEW_H__ */
