/* -*- Mode: C; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/*
    Gpredict: Real-time satellite tracking and orbit prediction program

    Copyright (C)  2001-2006  Alexandru Csete, OZ9AEC.

    Authors: Alexandru Csete <csete@users.sourceforge.net>

    Comments, questions and bugreports should be submitted via
    http://sourceforge.net/projects/groundstation/
    More details can be found at the project home page:

            http://groundstation.sourceforge.net/
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, visit http://www.fsf.org/
*/
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <glib/gprintf.h>
#include <time.h>
#include <sys/time.h>
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "sat-log.h"


const gchar *SRC_TO_STR[] = {N_("NONE"), N_("HAMLIB"), N_("GPREDICT")};

/** FIXME: Conversion table HAMLIB_LEVEL => GPREDICT_LEVEL */


static void manage_debug_message (sat_log_src_t source,
				  sat_log_level_t debug_level,
				  const gchar *message);


void
sat_log_init        ()
{

}


void
sat_log_close       ()
{
}


void
sat_log_log         (sat_log_level_t level, const gchar *fmt, ...)
{
	gchar      *msg;       /* formatted debug message */
	gchar     **msgv;      /* debug message line by line */
	guint       numlines;  /* the number of lines in the message */
	guint       i;
	va_list     ap;


	va_start (ap, fmt);

	/* create character string and split it in case
	   it is a multi-line message */
	msg = g_strdup_vprintf (fmt, ap);

	/* remove trailing \n */
	g_strchomp (msg);

	/* split the message in case it is a multiline message */
	msgv = g_strsplit_set (msg, "\n", 0);
	numlines = g_strv_length (msgv);

	g_free (msg);

	/* for each line in msgv, call the real debug handler
	   which will print the debug message and save it to
	   a logfile
	*/
	for (i = 0; i < numlines; i++) {
		manage_debug_message (SAT_LOG_SRC_GPREDICT, level, msgv[i]);
	}

	va_end(ap);

	g_strfreev (msgv);
	

}


 
void
sat_log_set_visible (gboolean visible)
{

}


void
sat_log_set_level   (sat_log_level_t level)
{
}



static void
manage_debug_message (sat_log_src_t source,
		      sat_log_level_t debug_level,
		      const gchar *message)
{
	gchar msg_time[50];
	guint size;
	struct timeval tval;
	struct timezone tzone;
	time_t t;
	gint x;


	/* get the time */
	x = gettimeofday (&tval, &tzone);
	t = (time_t ) tval.tv_sec;
	size = strftime (msg_time, 48, "%Y/%m/%d %H:%M:%S", localtime (&t));
	if (size < 49) {
		msg_time[size] = '\0';
	}
	else {
		msg_time[49] = '\0';
	}

	g_fprintf (stderr,
		   "%s%s%s%s%d%s%s\n",
		   msg_time,
		   SAT_LOG_MSG_SEPARATOR,
		   SRC_TO_STR[source],
		   SAT_LOG_MSG_SEPARATOR,
		   debug_level,
		   SAT_LOG_MSG_SEPARATOR,
		   message);

}
