/* $Id: userinfo.cc,v 1.7 2002/03/10 18:37:10 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "transient.h"

#include "msgbox.h"
#include "userinfo.h"
#include "importglobals.h"

GtkWidget *nfo=NULL;

void uinfo_pop(char *username) {
  GtkWidget *v1,*t,*lw[20],*hs,*h1,*bt;
  char title[256],bz[64];
  int i;
  struct passwd *pss;
  struct group  *gss;

  if (nfo!=NULL)
    return;

  pss=getpwnam(username);
  gss=NULL;
  if (pss!=NULL)
    gss=getgrgid(pss->pw_gid);

  if ((pss==NULL)||(gss==NULL)) {
    message_box(MainWindow,
		"User database lookup failed.",
		"Failure",
		MSGBOX_OK,
		MSGBOX_ICON_ERROR);
    return;
  }

  nfo=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_transient_for(GTK_WINDOW(nfo),MainWindow);
  gtk_window_set_position(GTK_WINDOW(nfo),GTK_WIN_POS_CENTER);
  gtk_widget_realize(nfo);
  gtk_window_set_policy(GTK_WINDOW(nfo),TRUE,TRUE,TRUE);
  gethostname(bz,256);
  snprintf(title,256,"User Info (%s)",bz);
  title[255]=0;
  gtk_window_set_title(GTK_WINDOW(nfo),title);
  gtk_container_set_border_width(GTK_CONTAINER(nfo),4);

  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(nfo),v1);

  t=gtk_table_new(7,2,FALSE);
  gtk_box_pack_start(GTK_BOX(v1),t,TRUE,TRUE,2);

  lw[0]=boxed_label_new("Username");
  lw[1]=boxed_label_new("Real Name");
  lw[2]=boxed_label_new("UID");
  lw[3]=boxed_label_new("GID");
  lw[4]=boxed_label_new("Group");
  lw[5]=boxed_label_new("Home");
  lw[6]=boxed_label_new("Shell");

  lw[7]=boxed_label_new(pss->pw_name);
  lw[8]=boxed_label_new(pss->pw_gecos);
  snprintf(bz,64,"%d",(int)(pss->pw_uid));
  bz[63]=0;
  lw[9]=boxed_label_new(bz);
  snprintf(bz,64,"%d",(int)(pss->pw_gid));
  bz[63]=0;
  lw[10]=boxed_label_new(bz);
  lw[11]=boxed_label_new(gss->gr_name);
  lw[12]=boxed_label_new(pss->pw_dir);
  lw[13]=boxed_label_new(pss->pw_shell);
  
  for(i=0;i<7;i++) {
    gtk_table_attach_defaults(GTK_TABLE(t),lw[i],0,1,i,i+1);
    gtk_table_attach_defaults(GTK_TABLE(t),lw[i+7],1,2,i,i+1);
  }

  hs=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),hs,FALSE,TRUE,2);

  h1=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(h1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(h1), 5);

  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,FALSE,6);

  bt=gtk_button_new_with_label("Dismiss");
  GTK_WIDGET_SET_FLAGS(bt,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(h1),bt,TRUE,TRUE,0);

  gtk_signal_connect(GTK_OBJECT(bt),"clicked",
		     GTK_SIGNAL_FUNC(close_user_info),NULL);
  gtk_signal_connect (GTK_OBJECT (nfo), "destroy",
		      GTK_SIGNAL_FUNC (destroy_user_info), NULL);

  gtk_widget_grab_default(bt);

  gtk_widget_show(v1);
  gtk_widget_show(h1);
  gtk_widget_show(hs);
  gtk_widget_show(bt);

  for(i=0;i<14;i++)
    gtk_widget_show(lw[i]);

  gtk_widget_show(t);
  gtk_widget_show(nfo);
  gtk_grab_add(nfo);
}

void close_user_info(GtkWidget *w, gpointer data) {
  gtk_grab_remove(nfo);
  gtk_widget_destroy(nfo);
  nfo=NULL;
}

void destroy_user_info(GtkWidget *w,gpointer data) {
  nfo=NULL;
}

GtkWidget *boxed_label_new(char *s) {
  GtkWidget *a,*b;

  a=gtk_hbox_new(FALSE,5);
  b=gtk_label_new(s);
  gtk_box_pack_start(GTK_BOX(a),b,FALSE,FALSE,4);
  gtk_widget_show(b);
  return(a);
}
