dnl  This file is part of GQL.
dnl  
dnl  Original Copyright (C) 1999 Manush Dodunekov <manush@litecom.net>
dnl  Modified by Andreas Rottmann <rottmann@users.sourceforge.net>
dnl  Copyright (C) 2000 Andreas Rottmann
dnl   
dnl  This library is free software; you can redistribute it and/or
dnl  modify it under the terms of the GNU Library General Public
dnl  License as published by the Free Software Foundation; either
dnl  version 2 of the License, or (at your option) any later version.
dnl   
dnl  This library is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl  Library General Public License for more details.
dnl  
dnl  You should have received a copy of the GNU Library General Public License
dnl  along with this library; see the file COPYING.  If not, write to
dnl  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
dnl  Boston, MA 02111-1307, USA.



dnl Local macros for GQL


dnl Macro: AC_CHECK_CXX_STL
dnl Sets $ac_cv_cxx_stl to yes or no
dnl defines HAVE_CXX_STL if ok

AC_DEFUN(AC_CHECK_CXX_STL,
[
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_MSG_CHECKING([whether STL is available])
AC_CACHE_VAL(ac_cv_cxx_stl,
[
AC_TRY_COMPILE([
#include <set>

using namespace std;
],[
set<int> t;
t.insert(t.begin(),1);
set<int>::iterator i=t.find(1);
],
ac_cv_cxx_stl=yes,
ac_cv_cxx_stl=no)
])
AC_MSG_RESULT($ac_cv_cxx_stl)
if test "x$ac_cv_cxx_stl" = "xyes"
then
	AC_DEFINE(HAVE_CXX_STL)
fi
AC_LANG_RESTORE
])



dnl Macro: AC_CHECK_CXX_EH
dnl Sets $ac_cv_cxx_eh to yes or no

AC_DEFUN(AC_CHECK_CXX_EH,
[
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_MSG_CHECKING([whether the C++ compiler ($CXX $CXXFLAGS) has correct exception handling])
AC_CACHE_VAL(ac_cv_cxx_eh,
[
AC_TRY_RUN(
[
#include <exception>
#include <string.h>

using namespace std;

struct test : public exception {
	virtual const char* what() const throw() { return "test"; }
};

static void func() { throw test(); }
int main(void)
{
	try {
		func();
	} catch(exception& e) {
		return (strcmp(e.what(),"test")!=0);
	} catch(...) { return 1; }
	return 1;
}
],
ac_cv_cxx_eh=yes,
ac_cv_cxx_eh=no)
])
AC_MSG_RESULT([$ac_cv_cxx_eh])
if test "x$ac_cv_cxx_eh" = "xyes"
then
	AC_DEFINE(HAVE_CXX_EH)
fi
AC_LANG_RESTORE
])


dnl Macro: AC_CHECK_CXX_NS
dnl Test if the c++ compiler supports namespaces
dnl Set $ac_cv_cxx_ns to either yes or no
dnl Define HAVE_CXX_NS if yes

AC_DEFUN(AC_CHECK_CXX_NS,
[
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_MSG_CHECKING([whether the C++ compiler ($CXX $CXXFLAGS) supports namespaces])
AC_CACHE_VAL(ac_cv_cxx_ns,
[
AC_TRY_COMPILE([
namespace A {
	namespace B {
		struct X {};
	};
};
],[
	A::B::X x;
],
ac_cv_cxx_ns=yes,
ac_cv_cxx_ns=no)
])

AC_MSG_RESULT([$ac_cv_cxx_ns])

if test "x$ac_cv_cxx_ns" = "xyes"
then
	AC_DEFINE(HAVE_CXX_NS)
fi
AC_LANG_RESTORE
])


dnl Macro: AC_CHECK_THREADS
dnl Test if we should compile with thread support
AC_DEFUN(AC_CHECK_THREADS,
[
AC_MSG_CHECKING([whether to enable threads])
AC_ARG_ENABLE(threads,
[  --enable-threads        Enable threads],
	enable_threads=yes
)

if test "x$enable_threads" = "xyes" 
then
	AC_MSG_RESULT(yes)

# ok, now check for pthreads
AC_CHECK_HEADER(pthread.h,[
	AC_DEFINE(HAVE_PTHREAD_H)
	],[AC_MSG_ERROR([pthread.h not found. Consider not using --enable-threads])])

# check if pthreads are in our default library environment
AC_CHECK_FUNCS(pthread_create,pthreads_ok=yes,pthreads_ok=no)
THREAD_LIBS=""

if test "x$pthreads_ok" != xyes
then

AC_CHECK_LIB(pthread,pthread_create,
	pthreads_ok=yes
	THREAD_LIBS="-lpthread",pthreads_ok=no)
fi

if test "x$pthreads_ok" != xyes
then

# try libc_r (*BSD)
	AC_CHECK_LIB(c_r,pthread_create,
	pthreads_ok=yes
	THREAD_LIBS="-lc_r",pthreads_ok=no)
fi

if test "x$pthreads_ok" = xyes
then
# now we know we can use pthreads
	AC_DEFINE(ENABLE_THREADS)
        gql_threads=yes
	CPPFLAGS="-D_REENTRANT $CPPFLAGS"
else
	AC_MSG_ERROR([Unable to find a POSIX threads environment.])
fi
else
	AC_MSG_RESULT(no)
fi
AC_SUBST(THREAD_LIBS)
])



dnl Macro: AC_CHECK_DOXYGEN
dnl Checks for doxygen and perl, sets $doxygen to path if both are found
dnl Otherwise, $doxygen will be empty
AC_DEFUN(AC_CHECK_DOXYGEN,
[
	AC_PATH_PROG(doxygen,doxygen)
	AC_PATH_PROG(perl,perl)
	if test "x$doxygen" = "x" || test "x$perl" = "x"
	then
		doxygen=""
	fi
	AC_SUBST(doxygen)
	AC_SUBST(perl)
])

