#include "config.h"

#include "connection.h"
#include "statement.h"
#include "result-set.h"
#include "database-metadata.h"

#include "gql++/exception.h"

namespace GQL
{

namespace MySQL
{

#if defined(GQL_THREADS)
SigC::Threads::Mutex MyConnection::global_mutex_;
#endif

MyConnection::MyConnection(const string& host,
                           const string& port,
                           const map<string, string>& info,
                           const string& db,
                           const string& url,
                           MyDriver *driver)
{
  map<string, string>::const_iterator user, password;
  bool ok;
  
  if ((user = info.find("user")) == info.end())
    throw SQLException("The user property is missing. It is manadatory");
  if ((password = info.find("password")) == info.end())
    throw SQLException("The password property is missing. It is manadatory");

  driver_ = driver;
  url_ = url;
  database_ = db;
  port_ = port;
  host_ = host;

  global_lock();
  conn_ = mysql_init(NULL);
  ok = mysql_real_connect(conn_, host.c_str(),
                          (*user).second.c_str(), (*password).second.c_str(),
                          db.c_str(), atoi(port.c_str()), NULL, 0);
  global_unlock();

  driver_->reference();
  
  if (!ok)
    throw SQLException(string("Connection failed: ") + mysql_error(conn_));

  metadata_ = new MyDatabaseMetaData(this);
}

MyConnection::~MyConnection()
{
  close();
  
  driver_->unreference();
}

void MyConnection::close()
{
  lock();
  mysql_close(conn_);
  unlock();
  conn_ = 0;
}

Statement *MyConnection::create_statement()
{
  return(new MyStatement(this));
}

PreparedStatement *MyConnection::prepare_statement(const string& url)
{
  return(0);
}

CallableStatement * MyConnection::prepare_call(const string& url)
{
  return(0);
}

void MyConnection::commit()
{
}

void MyConnection::set_auto_commit(bool auto_commit)
{
  if (auto_commit_ == auto_commit)
    return;
  if (auto_commit_)
    
  auto_commit_ = auto_commit;
}

void MyConnection::rollback()
{
}

string MyConnection::get_catalog() const
{
  string empty;
  
  return(empty);
}

string MyConnection::native_sql(const string& sql) const
{
  string empty;

  return(empty);
}

DatabaseMetaData *MyConnection::get_meta_data()
{
  return(new MyDatabaseMetaData(this));
}

ResultSet *MyConnection::exec_sql(const string& sql)
{
  MYSQL_RES *res;
  ResultSet *result;
  bool ok;
  
  lock();
  ok = mysql_real_query(conn_, sql.c_str(), sql.length()) == 0;
  res = mysql_store_result(conn_);
  unlock();
  
  if (!ok || !res)
    throw SQLException(mysql_error(conn_));
  
  result = new MyResultSet(this, res);
  
  destroy.connect(result->destroy.slot());

  return(result);
}

}
}
