#include "config.h"

#include "driver.h"
#include "connection.h"
#include "gql++/exception.h"

namespace GQL
{

namespace MySQL
{

MyDriver::MyDriver(uC::PluginManager *mgr) : Driver(mgr, "mysql", "MySQL")
{
  set_version(0, 0);
};

bool MyDriver::accept_url(const string& url) const
{
  return(parse_url(url).size() > 0);
}

Connection *MyDriver::connect(const string& url,
                              const map<string, string>& info)
{
  props_ = parse_url(url, info);

  if (props_.size() == 0)
    return(0);

  return(new MyConnection(host(), port(), props_, database(), url, this));
}

vector<DriverPropertyInfo> MyDriver::get_property_info(
        const string& url,
        const map<string, string>& props) const
{
  vector<DriverPropertyInfo> prop_info;

  return(prop_info);
}
                                               
map<string, string> MyDriver::parse_url(
        const string& url,
        const map<string, string>& defaults) const
{
  map<string, string> url_props(defaults);
  string::size_type pos = 0, new_pos;
  int state = 0;
  bool ok = false, done = false;
  
  for (;;)
  {
    new_pos = url.find_first_of(":/;=&?", pos);

    switch (state)
    {
      case 0:
        if (url[new_pos] != ':' ||
            url.substr(pos, new_pos - pos) != "gql")
          done = true;
        state++;
        break;
      case 1:
        if (url[new_pos] != ':' ||
            url.substr(pos, new_pos - pos) != get_id())
          done = true;
        state++;
        break;
      case 2:
        if (new_pos == string::npos)
        {
          url_props["MyDBNAME"] = url.substr(pos, new_pos - pos);
          done = true;
          ok = true;
        }
        else if (url[new_pos] == '/')
          state++;
        else
          done = true;
        break;
      case 3:
        if (url[new_pos] == '/')
          state++;
        else
          done = true;
        break;
      case 4:
        if (url[new_pos] == '/')
          state += 2; // Jump over port
        else if (url[new_pos] == ':')
          state++;
        else
          done = true;
        
        url_props["MyHOST"] = url.substr(pos, new_pos - pos);
        break;
      case 5:
        if (url[new_pos] == '/')
          url_props["MyPORT"] = url.substr(pos, new_pos - pos);
        else
          done = true;
        break;
      case 6:
        if (new_pos == string::npos)
        {
          url_props["MyDBNAME"] = url.substr(pos, new_pos - pos);
          ok = true;
        }
        done = true;
        break;
      default:
        done = true;
    }
    
    if (done)
      break;

    pos = new_pos + 1;
  }
  
  if (!ok)
    url_props.erase(url_props.begin(), url_props.end());
  
  return(url_props);
}

static string empty_string;

const string& MyDriver::host() const
{
  map<string, string>::const_iterator i = props_.find("MyHOST");
  
  if (i == props_.end())
    return(empty_string);
  else
    return((*i).second);
}

const string& MyDriver::port() const
{
  map<string, string>::const_iterator i = props_.find("MyPORT");
  
  if (i == props_.end())
    return(empty_string);
  else
    return((*i).second);
}

const string& MyDriver::database() const
{
  map<string, string>::const_iterator i = props_.find("MyDBNAME");
  
  if (i == props_.end())
    return(empty_string);
  else
    return((*i).second);
}

extern "C" uC::Plugin *ucxx_mysql_plugin_init(uC::PluginManager *mgr)
{
  Driver *driver = new MyDriver(mgr);

  manage(driver);

  return(driver);
}


}
}

