/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GQL_PG_OBJECT_H)
#define __INC_GQL_PG_OBJECT_H

#include <postgresql/libpq-fe.h>

#include "gql++/object.h"

namespace GQL
{

namespace PG
{

class PGConnection;

class PGSQLObject : public SQLObject
{
  public:
    PGSQLObject(PGConnection *conn, PGconn *pg_conn) {
      conn_ = conn;
      pg_conn_ = pg_conn;
    }
    
    virtual Blob *to_blob() const;
    virtual bool from_blob(const Blob *);
  private:
    PGConnection *conn_;
    PGconn *pg_conn_;
};

class PGBlob : public Blob
{
  public:
    PGBlob(Oid oid, PGConnection *conn, PGconn *pg_conn);
    ~PGBlob();
    
    virtual void open(openmode = in);
    virtual bool is_open() { return fd_ >= 0; }
    virtual void close();
    
    virtual int write(const void *data, int len);
    virtual int read(void *data, int len);
    virtual int seek(int offset, seek_dir whence);
    virtual int tell() const;

    Oid oid() const { return oid_; }
  private:
    Oid oid_;
    PGConnection *conn_;
    PGconn *pg_conn_;
    int fd_;
};

}
}

#endif
