/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PG_RESULT_SET_METADATA_H)
#define __INC_PG_RESULT_SET_METADATA_H

#include <postgresql/libpq-fe.h>

#include "gql++/connection.h"
#include "gql++/result-set-metadata.h"
#include "gql++/object.h"

namespace GQL
{
  
namespace PG
{

class PGResultSetMetaData : public ResultSetMetaData
{
  public:
    PGResultSetMetaData(Connection *conn, PGresult *result);
    ~PGResultSetMetaData();
    
    virtual int column_count();
    virtual string get_column_label(int i);
    virtual string get_column_name(int i);
    virtual const SQLType& get_column_type(int i);
  private:
    PGresult *result_;
    Connection *conn_;
    SQLType *column_types_;
};

}

}

#endif
