/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PG_RESULTSET_H)
#define __INC_PG_RESULTSET_H

#include <postgresql/libpq-fe.h>

#include "gql++/result-set.h"

namespace GQL
{

namespace PG
{

class PGResultSet : public ResultSet
{
  public:
    PGResultSet(Connection *conn, PGresult *result) : ResultSet(conn) {
      result_ = result;
      rowno_ = -1;
    }
    virtual ~PGResultSet();
    
    virtual bool next() throw(SQLException);
    
    virtual void get(int i, SQLObject *obj) const throw(SQLException);
    virtual ResultSetMetaData *get_meta_data();
  private:
    int rowno_;
    PGresult *result_;
};

}

}

#endif
