#include "statement.h"

namespace GQL
{

namespace PG
{

PGStatement::~PGStatement()
{
  close();
}

void PGStatement::close()
{
  if (result_set_)
    result_set_->unreference();
}


bool PGStatement::execute(const string& sql)
{
  clear_warnings();
  
  result_set_ = dynamic_cast<PGResultSet *>(
          dynamic_cast<PGConnection *>(get_connection())->exec_sql(sql));

  return(true);
}

ResultSet *PGStatement::execute_query(const string& sql)
{
  execute(sql);
  
  return(result_set_);
}

int PGStatement::execute_update(const string& sql)
{
  execute(sql);
  
  return(0);
}

}
}
