/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_RESULTSET_H)
#define __INC_RESULTSET_H

#include "gql++/warnable.h"
#include "gql++/object.h"

namespace GQL
{

class Connection;
class ResultSetMetaData;

class ResultSet : public Warnable
{
  public:
    /** Constructor
     * \param conn Connection this ResultSet belongs to. */
    ResultSet(Connection *conn) : conn_(conn) { }
    /** Destructor */
    virtual ~ResultSet();

    virtual bool next() throw(SQLException) = 0;
    
    /** Get a value.
     * \param col Column index.
     * \param obj SQLObject to fetch value into.
     * \return \a obj. */
    virtual SQLObject *get(int col, SQLObject *obj) 
      const throw(SQLException) = 0;
    
    virtual const ResultSetMetaData *get_meta_data() const = 0;

    const Connection *get_connection() const { return(conn_); }
    Connection *get_connection() { return(conn_); }
  private:
    Connection *conn_;
};

}


#endif
