/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef UI_FILEOPS_H
#define UI_FILEOPS_H

const gchar *homedir(void);
gint isname(const gchar *s);
gint isfile(const gchar *s);
gint isdir(const gchar *s);
gint filesize(const gchar *s);
time_t filetime(const gchar *s);
gint copy_file(const gchar *s, const gchar *t);
gint move_file(const gchar *s, const gchar *t);
gchar *get_current_dir(void);

/* return True on success, it is up to you to free
 * the lists with path_list_free()
 */
gint path_list(const gchar *path, GList **files, GList **dirs);
void path_list_free(GList *list);

long checksum_simple(const gchar *path);


gchar *unique_filename(const gchar *path, const gchar *ext, const gchar *divider, gint pad);

const gchar *filename_from_path(const gchar *path);
gchar *remove_level_from_path(const gchar *path);
gchar *concat_dir_and_file(const gchar *base, const gchar *name);

gchar *remove_extension_from_path(const gchar *path);

/* warning note: this modifies path string! */
void parse_out_relatives(gchar *path);

gint file_in_path(const gchar *name);

#endif



