/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

/*
 * config.h is generated by configure.  It contains the results
 * of probing for features, options etc.  It should be the first
 * file included in your .cc file.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gnuradio/io_signature.h>
#include "prune_vectors_impl.h"

namespace gr {
  namespace dab {

    prune_vectors::sptr
    prune_vectors::make(size_t itemsize, unsigned int length, unsigned int prune_start, unsigned int prune_end)
    {
      return gnuradio::get_initial_sptr
              (new prune_vectors_impl(itemsize, length, prune_start, prune_end));
    }

    prune_vectors_impl::prune_vectors_impl(size_t itemsize, unsigned int length, unsigned int prune_start,
                                           unsigned int prune_end)
            : gr::sync_block("prune_vectors",
                             gr::io_signature::make(1, 1, itemsize * length),
                             gr::io_signature::make(1, 1, itemsize * (length - prune_start - prune_end))),
              d_itemsize(itemsize), d_length(length), d_prune_start(prune_start), d_prune_end(prune_end)
    {
      if (prune_start + prune_end > length)
        fprintf(stderr, "want to prune more than existing");
    }


    int
    prune_vectors_impl::work(int noutput_items,
                             gr_vector_const_void_star &input_items,
                             gr_vector_void_star &output_items)
    {
      char const *in = (const char *) input_items[0];
      char *out = (char *) output_items[0];

      for (int i = 0; i < noutput_items; i++) {
        memcpy(out, in + d_prune_start * d_itemsize, (d_length - d_prune_start - d_prune_end) * d_itemsize);
        in += d_length * d_itemsize;
        out += (d_length - d_prune_start - d_prune_end) * d_itemsize;
      }

      return noutput_items;
    }

  }
}
